/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.player;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.translation.Translatable;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.argument.GameModeArgumentType;
import org.bukkit.GameMode;
import org.bukkit.GameRules;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class GameModeCommand {
    private final TweaksPlugin plugin;

    public GameModeCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().gamemode.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.gamemode"))).then(((RequiredArgumentBuilder)Commands.argument((String)"gamemode", (ArgumentType)new GameModeArgumentType()).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)ArgumentTypes.players()).requires(stack -> stack.getSender().hasPermission("tweaks.command.gamemode.others"))).executes(context -> {
            PlayerSelectorArgumentResolver players = (PlayerSelectorArgumentResolver)context.getArgument("players", PlayerSelectorArgumentResolver.class);
            return this.gamemode((CommandContext<CommandSourceStack>)context, (List)players.resolve((CommandSourceStack)context.getSource()));
        }))).executes(context -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            if (sender instanceof Player) {
                Player player = (Player)sender;
                return this.gamemode((CommandContext<CommandSourceStack>)context, List.of(player));
            }
            this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
            return 0;
        }))).build();
        registrar.register(command, "Change your own or someone else's game mode", this.plugin.commands().gamemode.aliases);
    }

    private int gamemode(CommandContext<CommandSourceStack> context, List<Player> resolve) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        GameMode gamemode = (GameMode)context.getArgument("gamemode", GameMode.class);
        resolve.forEach(player -> {
            player.setGameMode(gamemode);
            if (Boolean.FALSE.equals(player.getWorld().getGameRuleValue(GameRules.SEND_COMMAND_FEEDBACK))) {
                return;
            }
            this.plugin.bundle().sendMessage((Audience)player, "command.gamemode.changed.self", new TagResolver[]{Placeholder.component((String)"gamemode", (ComponentLike)Component.translatable((Translatable)gamemode))});
            if (!sender.equals(player)) {
                this.plugin.bundle().sendMessage((Audience)sender, "command.gamemode.changed.others", new TagResolver[]{Placeholder.component((String)"gamemode", (ComponentLike)Component.translatable((Translatable)gamemode)), Placeholder.parsed((String)"player", (String)player.getName())});
            }
        });
        return 1;
    }
}

