/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.item;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.GameRules;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class LoreCommand {
    private final TweaksPlugin plugin;

    public LoreCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().lore.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.lore");
        })).then(Commands.literal((String)"clear").executes(this::clear))).then(this.modify("append", (Command<CommandSourceStack>)((Command)this::append)))).then(this.modify("prepend", (Command<CommandSourceStack>)((Command)this::prepend)))).then(this.modify("set", (Command<CommandSourceStack>)((Command)this::set)))).then(this.replace())).build();
        registrar.register(command, "Change the lore of your items", this.plugin.commands().lore.aliases);
    }

    private LiteralArgumentBuilder<CommandSourceStack> replace() {
        return (LiteralArgumentBuilder)Commands.literal((String)"replace").then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"replacement", (ArgumentType)StringArgumentType.greedyString()).executes(this::replace)));
    }

    private LiteralArgumentBuilder<CommandSourceStack> modify(String literal, Command<CommandSourceStack> command) {
        return (LiteralArgumentBuilder)Commands.literal((String)literal).then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(command));
    }

    private int replace(CommandContext<CommandSourceStack> context) {
        return this.modifyLore(context, item -> {
            ItemLore data = (ItemLore)item.getData(DataComponentTypes.LORE);
            if (data == null || data.lines().isEmpty()) {
                return false;
            }
            ArrayList lore = new ArrayList(data.lines());
            String text = (String)context.getArgument("text", String.class);
            String replacement = (String)context.getArgument("replacement", String.class);
            TextReplacementConfig config = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(text).replacement((ComponentLike)MiniMessage.miniMessage().deserialize((Object)replacement)).build();
            lore.replaceAll(component -> component.replaceText(config));
            item.lore(lore);
            return !Objects.equals(data, item.getData(DataComponentTypes.LORE));
        });
    }

    private int append(CommandContext<CommandSourceStack> context) {
        return this.modifyLore(context, item -> {
            ArrayList<Component> lore = new ArrayList<Component>();
            Optional.ofNullable((ItemLore)item.getData(DataComponentTypes.LORE)).map(ItemLore::lines).ifPresent(lore::addAll);
            lore.addAll(this.getLore(context));
            item.lore(lore);
            return true;
        });
    }

    private int prepend(CommandContext<CommandSourceStack> context) {
        return this.modifyLore(context, item -> {
            ArrayList<Component> lore = new ArrayList<Component>(this.getLore(context));
            Optional.ofNullable((ItemLore)item.getData(DataComponentTypes.LORE)).map(ItemLore::lines).ifPresent(lore::addAll);
            item.lore(lore);
            return true;
        });
    }

    private int set(CommandContext<CommandSourceStack> context) {
        return this.modifyLore(context, item -> {
            List<Component> lore = this.getLore(context);
            ItemLore data = (ItemLore)item.getData(DataComponentTypes.LORE);
            if (data != null && data.lines().equals(lore)) {
                return false;
            }
            item.lore(lore);
            return true;
        });
    }

    private int clear(CommandContext<CommandSourceStack> context) {
        return this.modifyLore(context, item -> {
            ItemLore lore = (ItemLore)item.getData(DataComponentTypes.LORE);
            if (lore == null || lore.lines().isEmpty()) {
                return false;
            }
            item.resetData((DataComponentType)DataComponentTypes.LORE);
            return true;
        });
    }

    private int modifyLore(CommandContext<CommandSourceStack> context, Function<ItemStack, Boolean> function) {
        String message;
        boolean success;
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ItemStack item = player.getInventory().getItemInMainHand();
        boolean bl = success = !item.isEmpty() && function.apply(item) != false;
        String string = item.isEmpty() ? "command.hold.item" : (message = success ? "command.item.lore" : "nothing.changed");
        if (Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRules.SEND_COMMAND_FEEDBACK)) || !success) {
            this.plugin.bundle().sendMessage((Audience)player, message);
        }
        return success ? 1 : 0;
    }

    private List<Component> getLore(CommandContext<CommandSourceStack> context) {
        String text = ((String)context.getArgument("text", String.class)).replace("\\t", "   ");
        return Arrays.stream(text.split("(\\\\n|<br>|<newline>)")).map(arg_0 -> ((MiniMessage)MiniMessage.miniMessage()).deserialize(arg_0)).collect(Collectors.toList());
    }
}

