/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.item;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.translation.Translatable;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.EnchantSuggestionProvider;
import org.bukkit.GameRules;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class EnchantCommand {
    private final TweaksPlugin plugin;

    public EnchantCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        int max = this.plugin.config().general.enchantmentOverflow ? 255 : RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).stream().mapToInt(Enchantment::getMaxLevel).max().orElse(10);
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().enchant.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.enchant");
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"enchantment", (ArgumentType)ArgumentTypes.resource((RegistryKey)RegistryKey.ENCHANTMENT)).suggests((SuggestionProvider)new EnchantSuggestionProvider(this.plugin)).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)max)).suggests(this::suggestLevels).executes(context -> this.enchant((CommandContext<CommandSourceStack>)context, (Integer)context.getArgument("level", Integer.TYPE))))).executes(context -> this.enchant((CommandContext<CommandSourceStack>)context, 1)))).build();
        registrar.register(command, "Enchant your tools", this.plugin.commands().enchant.aliases);
    }

    private CompletableFuture<Suggestions> suggestLevels(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Enchantment enchantment = (Enchantment)context.getLastChild().getArgument("enchantment", Enchantment.class);
        IntStream.rangeClosed(enchantment.getStartLevel(), enchantment.getMaxLevel()).mapToObj(String::valueOf).filter(s -> s.contains(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private int enchant(CommandContext<CommandSourceStack> context, int level) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        Enchantment enchantment = (Enchantment)context.getArgument("enchantment", Enchantment.class);
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType().isAir()) {
            this.plugin.bundle().sendMessage((Audience)player, "command.hold.item");
            return 0;
        }
        if (!this.plugin.config().general.unsafeEnchantments && !enchantment.canEnchantItem(item)) {
            this.plugin.bundle().sendMessage((Audience)player, "command.enchantment.applicable", new TagResolver[]{Placeholder.component((String)"item", (ComponentLike)Component.translatable((Translatable)item))});
            return 0;
        }
        if (!this.plugin.config().general.enchantmentOverflow) {
            level = Math.min(level, enchantment.getMaxLevel());
        }
        level = Math.max(level, enchantment.getStartLevel());
        item.addUnsafeEnchantment(enchantment, level);
        if (Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRules.SEND_COMMAND_FEEDBACK))) {
            this.plugin.bundle().sendMessage((Audience)player, "command.enchantment.applied", new TagResolver[]{Placeholder.component((String)"enchantment", (ComponentLike)enchantment.displayName(level).style(Style.empty()))});
        }
        return 1;
    }
}

