/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.listener;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.controller.ServiceController;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ChatListener
implements Listener {
    private final TweaksPlugin plugin;

    public ChatListener(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChat(AsyncChatEvent event) {
        if (!this.plugin.config().general.logChat) {
            event.viewers().remove(this.plugin.getServer().getConsoleSender());
        }
        if (!this.plugin.config().general.overrideChat) {
            return;
        }
        String messageContent = event.signedMessage().message();
        event.renderer((source, displayName, message, viewer) -> {
            ComponentLike arguments = Argument.tagResolver((TagResolver)this.plugin.serviceResolvers(source).resolvers(new TagResolver[]{Placeholder.component((String)"display_name", (ComponentLike)displayName), Placeholder.component((String)"message", (ComponentLike)message), Placeholder.parsed((String)"message_content", (String)messageContent), this.createDeleteTag(source, viewer, event.signedMessage())}).build());
            return this.plugin.bundle().component("chat.format", viewer, arguments);
        });
    }

    private TagResolver.Single createDeleteTag(Player sender, Audience audience, SignedMessage message) {
        if (!(audience instanceof Player)) {
            return Placeholder.parsed((String)"delete", (String)"");
        }
        Player viewer = (Player)audience;
        if (!this.canDelete(viewer, sender)) {
            return Placeholder.parsed((String)"delete", (String)"");
        }
        Component component = this.plugin.bundle().component("chat.format.delete", (Audience)viewer);
        return Placeholder.component((String)"delete", (ComponentLike)component.clickEvent(ClickEvent.callback(ignored -> {
            if (!this.canDelete(viewer, sender)) {
                return;
            }
            this.plugin.getServer().getOnlinePlayers().forEach(all -> all.deleteMessage(message));
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)Duration.ofMillis(this.plugin.config().general.messageDeletionTimeout)).build()))));
    }

    private boolean canDelete(Player viewer, Player source) {
        if (source.equals((Object)viewer) && viewer.hasPermission("tweaks.chat.delete.own")) {
            return true;
        }
        if (this.services().isPresent() && this.getWeight(source) <= this.getChatDeleteWeight(viewer)) {
            return true;
        }
        return viewer.hasPermission("tweaks.chat.delete");
    }

    private int getChatDeleteWeight(Player player) {
        return this.services().map(services -> services.getChatDeleteWeight(player)).orElse(-1);
    }

    private int getWeight(Player player) {
        return this.services().map(services -> services.getWeight(player)).orElse(-1);
    }

    private Optional<ServiceController> services() {
        return Optional.ofNullable(this.plugin.serviceController());
    }
}

