/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.controller;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.model.NamedLocation;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class DataController {
    private static final String TPA_TOGGLED = "tpa_toggled";
    private static final String MSG_TOGGLED = "msg_toggled";
    private final Connection connection;
    private final TweaksPlugin plugin;

    public DataController(TweaksPlugin plugin) {
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(new File(plugin.getDataFolder(), "saves.db")));
            this.plugin = plugin;
            this.createHomesTable();
            this.createSettingsTable();
            this.createWarpsTable();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to connect to database", e);
        }
    }

    public Optional<Location> getHome(OfflinePlayer player, String name) {
        try {
            return Optional.ofNullable(this.executeQuery("SELECT world, x, y, z, yaw, pitch FROM homes\nWHERE uuid = ? AND name = ?\n", resultSet -> resultSet.next() ? this.parseLocation((ResultSet)resultSet) : null, player.getUniqueId(), name));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get home location", e);
        }
    }

    public boolean hasHome(OfflinePlayer player, String name) {
        try {
            return Boolean.TRUE.equals(this.executeQuery("SELECT COUNT(*) FROM homes WHERE uuid = ? AND name = ?", resultSet -> resultSet.next() && resultSet.getInt(1) > 0, player.getUniqueId(), name));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to check if home exists", e);
        }
    }

    public int getHomeCount(OfflinePlayer player) {
        try {
            return Objects.requireNonNull(this.executeQuery("SELECT COUNT(*) FROM homes WHERE uuid = ?", resultSet -> resultSet.next() ? resultSet.getInt(1) : -1, player.getUniqueId()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get home count", e);
        }
    }

    public Set<NamedLocation> getHomes(OfflinePlayer player) {
        try {
            return Objects.requireNonNullElseGet(this.executeQuery("SELECT name, world, x, y, z, yaw, pitch FROM homes WHERE uuid = ?", this::parseNamedLocations, player.getUniqueId()), Set::of);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get homes", e);
        }
    }

    public boolean deleteHome(OfflinePlayer player, String name) {
        try {
            return this.executeUpdate("DELETE FROM homes WHERE uuid = ? AND name = ?", player.getUniqueId(), name) != 0;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete home", e);
        }
    }

    public void setHome(OfflinePlayer player, String name, Location location) {
        try {
            this.executeUpdate("DELETE FROM homes WHERE uuid = ? AND name = ?", player.getUniqueId(), name);
            this.executeUpdate("INSERT INTO homes (uuid, name, world, x, y, z, yaw, pitch) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", player.getUniqueId(), name, location.getWorld().key().asString(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set home", e);
        }
    }

    public boolean isTpaToggled(OfflinePlayer player) {
        return this.isSettingToggled(player, TPA_TOGGLED);
    }

    public boolean setTpaToggled(OfflinePlayer player, boolean toggled) {
        return this.setSettingToggled(player, toggled, TPA_TOGGLED);
    }

    public boolean toggleTpa(OfflinePlayer player) {
        return this.toggleSetting(player, TPA_TOGGLED);
    }

    public boolean isMsgToggled(OfflinePlayer player) {
        return this.isSettingToggled(player, MSG_TOGGLED);
    }

    public boolean setMsgToggled(OfflinePlayer player, boolean toggled) {
        return this.setSettingToggled(player, toggled, MSG_TOGGLED);
    }

    public boolean toggleMsg(OfflinePlayer player) {
        return this.toggleSetting(player, MSG_TOGGLED);
    }

    private boolean isSettingToggled(OfflinePlayer player, String setting) {
        try {
            return Boolean.TRUE.equals(this.executeQuery("SELECT COUNT(*) FROM settings WHERE uuid = ? AND setting = ?", resultSet -> resultSet.next() && resultSet.getInt(1) > 0, player.getUniqueId(), setting));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to check if setting is toggled", e);
        }
    }

    private boolean setSettingToggled(OfflinePlayer player, boolean toggled, String setting) {
        try {
            return toggled ? this.executeUpdate("INSERT OR IGNORE INTO settings (uuid, setting) VALUES (?, ?)", player.getUniqueId(), setting) != 0 : this.removeSetting(player, setting);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set setting toggled", e);
        }
    }

    private boolean removeSetting(OfflinePlayer player, String setting) {
        try {
            return this.executeUpdate("DELETE FROM settings WHERE uuid = ? AND setting = ?", player.getUniqueId(), setting) != 0;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to remove setting", e);
        }
    }

    private boolean toggleSetting(OfflinePlayer player, String setting) {
        boolean toggled = this.isSettingToggled(player, setting);
        return this.setSettingToggled(player, !toggled, setting) != toggled;
    }

    public Optional<Location> getWarp(String name) {
        try {
            return Optional.ofNullable(this.executeQuery("SELECT world, x, y, z, yaw, pitch FROM warps WHERE name = ?", resultSet -> {
                if (!resultSet.next()) {
                    return null;
                }
                return this.parseLocation((ResultSet)resultSet);
            }, name));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get warp location", e);
        }
    }

    public Set<NamedLocation> getWarps() {
        try {
            return Objects.requireNonNullElseGet(this.executeQuery("SELECT name, world, x, y, z, yaw, pitch FROM warps", this::parseNamedLocations, new Object[0]), Set::of);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get warps", e);
        }
    }

    public boolean deleteWarp(String name) {
        try {
            return this.executeUpdate("DELETE FROM warps WHERE name = ?", name) != 0;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete warp", e);
        }
    }

    public void setWarp(String name, Location location) {
        try {
            this.executeUpdate("INSERT INTO warps (name, world, x, y, z, yaw, pitch)\nVALUES (?, ?, ?, ?, ?, ?, ?)\nON CONFLICT(name) DO UPDATE SET\n world = excluded.world,\n x = excluded.x,\n y = excluded.y,\n z = excluded.z,\n yaw = excluded.yaw,\n pitch = excluded.pitch\n", name, location.getWorld().key().asString(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set warp", e);
        }
    }

    private Set<NamedLocation> parseNamedLocations(ResultSet resultSet) throws SQLException {
        HashSet<NamedLocation> homes = new HashSet<NamedLocation>();
        while (resultSet.next()) {
            Location location = this.parseLocation(resultSet);
            if (location == null) continue;
            homes.add(new NamedLocation(resultSet.getString("name"), location));
        }
        return homes;
    }

    private @Nullable Location parseLocation(ResultSet resultSet) throws SQLException {
        Key key = Key.key((String)resultSet.getString("world"));
        World world = this.plugin.getServer().getWorld(key);
        if (world == null) {
            return null;
        }
        double x = resultSet.getDouble("x");
        double y = resultSet.getDouble("y");
        double z = resultSet.getDouble("z");
        float yaw = resultSet.getFloat("yaw");
        float pitch = resultSet.getFloat("pitch");
        return new Location(world, x, y, z, yaw, pitch);
    }

    private void createHomesTable() throws SQLException {
        this.executeUpdate("CREATE TABLE IF NOT EXISTS homes (\n  uuid TEXT NOT NULL,\n  name TEXT NOT NULL,\n  world TEXT NOT NULL,\n  x DOUBLE NOT NULL,\n  y DOUBLE NOT NULL,\n  z DOUBLE NOT NULL,\n  yaw FLOAT NOT NULL,\n  pitch FLOAT NOT NULL,\n  UNIQUE (uuid, name)\n)", new Object[0]);
    }

    private void createSettingsTable() throws SQLException {
        this.executeUpdate("CREATE TABLE IF NOT EXISTS settings (\n  uuid TEXT NOT NULL,\n  setting TEXT NOT NULL,\n  UNIQUE (uuid, setting)\n)", new Object[0]);
    }

    private void createWarpsTable() throws SQLException {
        this.executeUpdate("CREATE TABLE IF NOT EXISTS warps (\n  name TEXT NOT NULL UNIQUE PRIMARY KEY,\n  world TEXT NOT NULL,\n  x DOUBLE NOT NULL,\n  y DOUBLE NOT NULL,\n  z DOUBLE NOT NULL,\n  yaw FLOAT NOT NULL,\n  pitch FLOAT NOT NULL\n)", new Object[0]);
    }

    private <T> @Nullable T executeQuery(String query, ThrowingFunction<ResultSet, T> mapper, Object ... parameters) throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(query);){
            T t;
            block13: {
                for (int i = 0; i < parameters.length; ++i) {
                    preparedStatement.setObject(i + 1, parameters[i]);
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    t = ThrowingFunction.unchecked(mapper).apply(resultSet);
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return t;
        }
    }

    private int executeUpdate(String query, Object ... parameters) throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(query);){
            for (int i = 0; i < parameters.length; ++i) {
                preparedStatement.setObject(i + 1, parameters[i]);
            }
            int n = preparedStatement.executeUpdate();
            return n;
        }
    }

    @FunctionalInterface
    protected static interface ThrowingFunction<T, R> {
        public @Nullable R apply(T var1) throws SQLException;

        public static <T, R> ThrowingFunction<T, R> unchecked(ThrowingFunction<T, R> f) {
            return f;
        }
    }
}

