/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.tpa;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.RequestSuggestionProvider;
import net.thenextlvl.tweaks.controller.TPAController;
import org.bukkit.GameRule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class TPAcceptCommand {
    private final TweaksPlugin plugin;

    public TPAcceptCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands commands) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().teleportAccept.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.tpa.accept");
        })).then(Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).suggests((SuggestionProvider)new RequestSuggestionProvider(this.plugin)).executes(context -> {
            Player sender = (Player)((CommandSourceStack)context.getSource()).getSender();
            PlayerSelectorArgumentResolver resolver = (PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class);
            Player target = (Player)((List)resolver.resolve((CommandSourceStack)context.getSource())).getFirst();
            Optional<TPAController.Request> type = this.plugin.tpaController().getRequest(sender, target);
            return TPAcceptCommand.accept(this.plugin, sender, target, type.map(TPAController.Request::type).orElse(TPAController.RequestType.TPA));
        }))).executes(context -> {
            Player sender = (Player)((CommandSourceStack)context.getSource()).getSender();
            List<TPAController.Request> requests = this.plugin.tpaController().getRequests(sender);
            TPAController.Request request = requests.isEmpty() ? null : requests.getFirst();
            return TPAcceptCommand.accept(this.plugin, sender, request != null ? request.player() : null, request != null ? request.type() : TPAController.RequestType.TPA);
        })).build();
        commands.register(command, "Accept a teleport request", this.plugin.commands().teleportAccept.aliases);
    }

    static int accept(TweaksPlugin plugin, Player sender, @Nullable Player player, TPAController.RequestType type) {
        if (player == null || !plugin.tpaController().removeRequest(sender, player, type)) {
            String message = player != null ? "command.tpa.no-request" : "command.tpa.no-requests";
            plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"player", (String)(player != null ? player.getName() : "null"))});
            return 0;
        }
        if (Boolean.TRUE.equals(sender.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK))) {
            plugin.bundle().sendMessage((Audience)sender, "command.tpa.accepted.self", new TagResolver[]{Placeholder.parsed((String)"player", (String)player.getName())});
            plugin.bundle().sendMessage((Audience)player, "command.tpa.accepted", new TagResolver[]{Placeholder.parsed((String)"player", (String)sender.getName())});
        }
        if (type.equals((Object)TPAController.RequestType.TPA)) {
            TPAcceptCommand.teleport(plugin, player, sender);
        } else {
            TPAcceptCommand.teleport(plugin, sender, player);
        }
        return 1;
    }

    private static void teleport(TweaksPlugin plugin, Player player, Player target) {
        plugin.teleportController().teleport(player, target.getLocation(), PlayerTeleportEvent.TeleportCause.COMMAND).thenAccept(success -> {
            String message;
            String string = message = success != false ? "command.tpa.teleported" : "command.teleport.cancelled";
            if (Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK)) || !success.booleanValue()) {
                plugin.bundle().sendMessage((Audience)player, message, new TagResolver[]{Placeholder.parsed((String)"player", (String)target.getName())});
            }
        });
    }
}

