/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.item;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.datacomponent.DataComponentTypes;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.GameRule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class RenameCommand {
    private final TweaksPlugin plugin;

    public RenameCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().rename.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.rename");
        })).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(this::rename))).build();
        registrar.register(command, "Changes the display name of the item in your hand", this.plugin.commands().rename.aliases);
    }

    private int rename(CommandContext<CommandSourceStack> context) {
        String message;
        boolean success;
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ItemStack item = player.getInventory().getItemInMainHand();
        String text = (String)context.getArgument("name", String.class);
        Component name = MiniMessage.miniMessage().deserialize((Object)text.replace("\\t", "  "));
        boolean bl = success = !name.equals(item.getData(DataComponentTypes.CUSTOM_NAME));
        if (success) {
            item.setData(DataComponentTypes.CUSTOM_NAME, (Object)name);
        }
        String string = item.isEmpty() ? "command.hold.item" : (message = success ? "command.item.rename" : "nothing.changed");
        if (Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK)) || !success) {
            this.plugin.bundle().sendMessage((Audience)player, message);
        }
        return success ? 1 : 0;
    }
}

