/*
 * Decompiled with CFR 0.152.
 */
package core.paper.item;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import core.paper.item.ActionItem;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;

@Deprecated
public class ItemBuilder
implements Cloneable {
    private final ItemStack itemStack;

    private ItemBuilder(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public static ItemBuilder of(ItemStack itemStack) {
        return new ItemBuilder(itemStack);
    }

    public static ItemBuilder of(Material material) {
        return new ItemBuilder(ItemStack.of((Material)material));
    }

    public static ItemBuilder of(Material material, int amount) {
        return new ItemBuilder(ItemStack.of((Material)material, (int)amount));
    }

    public <T> @Nullable T data(DataComponentType.Valued<T> type) {
        return (T)this.itemStack.getData(type);
    }

    public <T> Optional<T> optional(DataComponentType.Valued<T> type) {
        return Optional.ofNullable(this.itemStack.getData(type));
    }

    public <T> ItemBuilder data(DataComponentType.Valued<T> type, T value) {
        this.itemStack.setData(type, value);
        return this;
    }

    public ItemBuilder data(DataComponentType.NonValued type) {
        this.itemStack.setData(type);
        return this;
    }

    public ItemBuilder resetData(DataComponentType type) {
        this.itemStack.resetData(type);
        return this;
    }

    public ItemBuilder unsetData(DataComponentType type) {
        this.itemStack.unsetData(type);
        return this;
    }

    public ItemBuilder itemName(Component name) {
        return this.data(DataComponentTypes.ITEM_NAME, name);
    }

    public ItemBuilder resetItemName() {
        return this.resetData((DataComponentType)DataComponentTypes.ITEM_NAME);
    }

    public ItemBuilder customName(Component name) {
        return this.data(DataComponentTypes.CUSTOM_NAME, name);
    }

    public ItemBuilder resetCustomName() {
        return this.resetData((DataComponentType)DataComponentTypes.CUSTOM_NAME);
    }

    public ItemBuilder lore(List<? extends ComponentLike> lines) {
        return this.data(DataComponentTypes.LORE, ItemLore.lore(lines));
    }

    public ItemBuilder lore(Component ... lore) {
        return this.lore(Arrays.asList(lore));
    }

    public ItemBuilder prependLore(List<? extends ComponentLike> lines) {
        ArrayList<? extends ComponentLike> lore = new ArrayList<ComponentLike>(lines);
        this.optional(DataComponentTypes.LORE).map(ItemLore::lines).ifPresent(lore::addAll);
        return this.lore(lore);
    }

    public ItemBuilder prependLore(Component ... lines) {
        return this.prependLore(Arrays.asList(lines));
    }

    public ItemBuilder appendLore(List<? extends ComponentLike> lines) {
        ArrayList<? extends ComponentLike> lore = new ArrayList<ComponentLike>();
        this.optional(DataComponentTypes.LORE).map(ItemLore::lines).ifPresent(lore::addAll);
        lore.addAll(lines);
        return this.lore(lore);
    }

    public ItemBuilder appendLore(Component ... lines) {
        return this.appendLore(Arrays.asList(lines));
    }

    public ItemBuilder resetLore() {
        return this.resetData((DataComponentType)DataComponentTypes.LORE);
    }

    public ItemBuilder rarity(ItemRarity rarity) {
        return this.data(DataComponentTypes.RARITY, rarity);
    }

    public ItemBuilder resetRarity() {
        return this.resetData((DataComponentType)DataComponentTypes.RARITY);
    }

    public ItemBuilder maxStackSize(int maxStackSize) {
        return this.data(DataComponentTypes.MAX_STACK_SIZE, maxStackSize);
    }

    public ItemBuilder amount(int amount) {
        this.itemStack.setAmount(Math.clamp((long)amount, 0, this.itemStack.getMaxStackSize()));
        return this;
    }

    public ItemBuilder add(int amount) {
        this.itemStack.add(amount);
        return this;
    }

    public ItemBuilder subtract(int amount) {
        this.itemStack.subtract(amount);
        return this;
    }

    public ItemBuilder unbreakable() {
        return this.data(DataComponentTypes.UNBREAKABLE);
    }

    @Deprecated(forRemoval=true)
    public ItemBuilder unbreakable(boolean showInTooltip) {
        return this.unbreakable();
    }

    public ItemBuilder resetUnbreakable() {
        return this.resetData((DataComponentType)DataComponentTypes.UNBREAKABLE);
    }

    public ItemBuilder customModelData(CustomModelData data) {
        return this.data(DataComponentTypes.CUSTOM_MODEL_DATA, data);
    }

    public ItemBuilder resetCustomModelData() {
        return this.resetData((DataComponentType)DataComponentTypes.CUSTOM_MODEL_DATA);
    }

    public ItemBuilder enchantmentGlint(boolean glint) {
        return this.data(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, glint);
    }

    public ItemBuilder addEnchantmentGlint() {
        return this.enchantmentGlint(true);
    }

    public ItemBuilder removeEnchantmentGlint() {
        return this.enchantmentGlint(false);
    }

    public ItemBuilder resetEnchantmentGlint() {
        return this.resetData((DataComponentType)DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE);
    }

    public ItemBuilder hideTooltip() {
        return this.data(DataComponentTypes.TOOLTIP_DISPLAY, (TooltipDisplay)TooltipDisplay.tooltipDisplay().hideTooltip(true).build());
    }

    public ItemBuilder showTooltip() {
        return this.resetData((DataComponentType)DataComponentTypes.TOOLTIP_DISPLAY);
    }

    public ItemBuilder profile(ResolvableProfile profile) {
        return this.data(DataComponentTypes.PROFILE, profile);
    }

    public ItemBuilder profile(PlayerProfile profile) {
        return this.profile(ResolvableProfile.resolvableProfile((PlayerProfile)profile));
    }

    public ItemBuilder profile(OfflinePlayer player) {
        return this.profile(player.getPlayerProfile());
    }

    public ItemBuilder profile(@Nullable UUID uuid) {
        return this.data(DataComponentTypes.PROFILE, (ResolvableProfile)ResolvableProfile.resolvableProfile().uuid(uuid).build());
    }

    public ItemBuilder profile(@Nullable String name) {
        return this.data(DataComponentTypes.PROFILE, (ResolvableProfile)ResolvableProfile.resolvableProfile().name(name).build());
    }

    public ItemBuilder profileValue(String base64) {
        return this.data(DataComponentTypes.PROFILE, (ResolvableProfile)ResolvableProfile.resolvableProfile().addProperty(new ProfileProperty("textures", base64)).build());
    }

    public ItemBuilder profileUrl(String url) {
        String texture = "{\"textures\":{\"SKIN\":{\"url\":\"" + url + "\"}}}";
        String base64 = Base64.getEncoder().encodeToString(texture.getBytes());
        return this.profileValue(base64);
    }

    public ActionItem withAction(ActionItem.Action action) {
        return new ActionItem(this.itemStack, action);
    }

    public ActionItem withAction(ActionItem.ClickAction action) {
        return this.withAction((ActionItem.Action)action);
    }

    public ActionItem withAction(ActionItem.PlayerAction action) {
        return this.withAction((ActionItem.Action)action);
    }

    public ActionItem withAction(ActionItem.RunAction action) {
        return this.withAction((ActionItem.Action)action);
    }

    public ActionItem withAction() {
        return this.withAction(() -> {});
    }

    public ItemStack item() {
        return this.itemStack;
    }

    public ItemBuilder clone() {
        try {
            return (ItemBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

