/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.warp;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.WarpSuggestionProvider;
import org.bukkit.GameRules;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class WarpCommand {
    private final TweaksPlugin plugin;

    public WarpCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().warp.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.warp");
        })).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider(this.plugin)).executes(this::warp))).build();
        registrar.register(command, "Warp to a location", this.plugin.commands().warp.aliases);
    }

    private int warp(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        String name = (String)context.getArgument("name", String.class);
        this.plugin.warpController().getWarp(name).thenAccept(warp -> warp.ifPresentOrElse(location -> this.plugin.teleportController().teleport(player, (Location)location, PlayerTeleportEvent.TeleportCause.COMMAND).thenAccept(success -> {
            String message = success != false ? "command.warp" : "command.teleport.cancelled";
            World world = ((CommandSourceStack)context.getSource()).getLocation().getWorld();
            if (Boolean.FALSE.equals(world.getGameRuleValue(GameRules.SEND_COMMAND_FEEDBACK)) && success.booleanValue()) {
                return;
            }
            this.plugin.bundle().sendMessage((Audience)player, message, new TagResolver[]{Placeholder.parsed((String)"name", (String)name)});
        }), () -> this.plugin.bundle().sendMessage((Audience)player, "command.warp.unknown", new TagResolver[]{Placeholder.parsed((String)"name", (String)name)})));
        return 1;
    }
}

