/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.home;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.HomeSuggestionProvider;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class SetHomeCommand {
    private final TweaksPlugin plugin;

    public SetHomeCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().setHome.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.home.set");
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HomeSuggestionProvider(this.plugin)).requires(stack -> stack.getSender().hasPermission("tweaks.command.home.set.named"))).executes(context -> this.setHome((CommandContext<CommandSourceStack>)context, (String)context.getArgument("name", String.class))))).executes(context -> this.setHome((CommandContext<CommandSourceStack>)context, this.plugin.config().homes.unnamedName))).build();
        registrar.register(command, "Set a home", this.plugin.commands().setHome.aliases);
    }

    private int setHome(CommandContext<CommandSourceStack> context, String name) {
        CompletableFuture.runAsync(() -> {
            Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
            if (player.hasPermission("tweaks.command.home.limit.bypass")) {
                this.setHome(name, player);
            } else if (this.plugin.dataController().hasHome((OfflinePlayer)player, name)) {
                this.setHome(name, player);
            } else {
                int limit = this.plugin.homeController().getMaxHomeCount(player);
                if (limit < 0) {
                    this.setHome(name, player);
                    return;
                }
                int count = this.plugin.dataController().getHomeCount((OfflinePlayer)player);
                if (count >= limit) {
                    this.plugin.bundle().sendMessage((Audience)player, "command.home.limit", Formatter.number((String)"limit", (Number)limit));
                } else {
                    this.setHome(name, player);
                }
            }
        }).exceptionally(throwable -> {
            this.plugin.getComponentLogger().error("Failed to set home", throwable);
            return null;
        });
        return 1;
    }

    private void setHome(String name, Player player) {
        this.plugin.dataController().setHome((OfflinePlayer)player, name, player.getLocation());
        this.plugin.bundle().sendMessage((Audience)player, "command.home.set.name", new TagResolver[]{Placeholder.parsed((String)"name", (String)name)});
    }
}

