/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.thenextlvl.nbt.tag.CompoundTagImpl;
import net.thenextlvl.nbt.tag.ListTag;
import net.thenextlvl.nbt.tag.Tag;
import net.thenextlvl.nbt.tag.ValueTag;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullUnmarked;

public sealed interface CompoundTag
extends ValueTag<Map<String, Tag>>
permits CompoundTagImpl {
    public static final byte ID = 10;

    public void forEach(BiConsumer<? super String, ? super Tag> var1);

    @Contract(pure=true)
    public Set<Map.Entry<String, Tag>> entrySet();

    @Contract(pure=true)
    public Set<String> keySet();

    @Contract(pure=true)
    public boolean isEmpty();

    @Contract(pure=true)
    public int size();

    @Contract(pure=true)
    public boolean containsKey(String var1);

    @NullUnmarked
    @Contract(pure=true)
    public <T extends Tag> T get(String var1);

    @Contract(pure=true)
    public <E extends Tag> ListTag<E> getAsList(String var1);

    @Contract(pure=true)
    public CompoundTag getAsCompound(String var1);

    @NullUnmarked
    @Contract(pure=true)
    public <T extends Tag> T getOrDefault(String var1, T var2);

    @Contract(pure=true)
    public <T extends Tag> Optional<T> optional(String var1);

    @Contract(value=" -> new", pure=true)
    public Builder toBuilder();

    @Contract(value=" -> new", pure=true)
    public static Builder builder() {
        return new CompoundTagImpl.Builder();
    }

    @Contract(value=" -> new", pure=true)
    public static CompoundTag empty() {
        return new CompoundTagImpl();
    }

    @Contract(value="_ -> new", pure=true)
    public static CompoundTag of(Map<String, Tag> value) {
        return new CompoundTagImpl(value);
    }

    public static sealed interface Builder
    permits CompoundTagImpl.Builder {
        @Contract(value="_, _ -> this", mutates="this")
        public Builder put(String var1, boolean var2);

        @Contract(value="_, _ -> this", mutates="this")
        public Builder put(String var1, byte ... var2);

        @Contract(value="_, _ -> this", mutates="this")
        public Builder put(String var1, int ... var2);

        @Contract(value="_, _ -> this", mutates="this")
        public Builder put(String var1, long ... var2);

        @Contract(value="_, _ -> this", mutates="this")
        public Builder put(String var1, Number var2);

        @Contract(value="_, _ -> this", mutates="this")
        public Builder put(String var1, String var2);

        @Contract(value="_, _ -> this", mutates="this")
        public Builder put(String var1, Tag var2);

        @Contract(value="_ -> this", mutates="this")
        public Builder putAll(CompoundTag var1);

        @Contract(value=" -> new", pure=true)
        public CompoundTag build();
    }
}

