/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag;

import java.io.IOException;
import java.util.Arrays;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.ByteArrayTag;
import net.thenextlvl.nbt.tag.ValueTagImpl;
import org.jetbrains.annotations.Contract;

final class ByteArrayTagImpl
extends ValueTagImpl<byte[]>
implements ByteArrayTag {
    public ByteArrayTagImpl(byte ... array) {
        super(array);
    }

    @Override
    public byte getTypeId() {
        return 7;
    }

    @Override
    @Contract(pure=true)
    public int size() {
        return ((byte[])this.value).length;
    }

    @Override
    @Contract(pure=true)
    public Byte get(int index) {
        return ((byte[])this.value)[index];
    }

    @Override
    public byte[] getValue() {
        return (byte[])((byte[])this.value).clone();
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeInt(((byte[])this.value).length);
        outputStream.write((byte[])this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ByteArrayTagImpl)) {
            return false;
        }
        ByteArrayTagImpl valueTag = (ByteArrayTagImpl)object;
        return Arrays.equals((byte[])this.value, (byte[])valueTag.value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((byte[])this.value);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{value=" + Arrays.toString((byte[])this.value) + "}";
    }
}

