/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.listener;

import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class BackListener
implements Listener {
    private final TweaksPlugin plugin;

    public BackListener(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent event) {
        switch (event.getCause()) {
            default: {
                throw new MatchException(null, null);
            }
            case ENDER_PEARL: 
            case COMMAND: 
            case PLUGIN: 
            case END_PORTAL: 
            case SPECTATE: 
            case UNKNOWN: {
                break;
            }
            case NETHER_PORTAL: 
            case END_GATEWAY: 
            case CONSUMABLE_EFFECT: 
            case DISMOUNT: 
            case EXIT_BED: {
                return;
            }
        }
        Player player = event.getPlayer();
        if (event.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.COMMAND) && event.getTo().equals((Object)this.plugin.backController().getLock(player))) {
            this.plugin.backController().unlock(player);
            return;
        }
        if (!player.hasPermission("tweaks.command.back")) {
            return;
        }
        this.plugin.backController().offerFirst(player, event.getFrom());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        if (player.getLocation().getY() < (double)player.getWorld().getMinHeight()) {
            return;
        }
        if (!player.hasPermission("tweaks.command.back")) {
            return;
        }
        this.plugin.backController().offerFirst(player, player.getLocation());
    }
}

