/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.item;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.registry.RegistryKey;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.UnenchantSuggestionProvider;
import org.bukkit.GameRule;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class UnenchantCommand {
    private final TweaksPlugin plugin;

    public UnenchantCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().unenchant.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.unenchant");
        })).then(Commands.argument((String)"enchantment", (ArgumentType)ArgumentTypes.resource((RegistryKey)RegistryKey.ENCHANTMENT)).suggests((SuggestionProvider)new UnenchantSuggestionProvider()).executes(this::unenchant))).build();
        registrar.register(command, "Unenchant your tools", this.plugin.commands().unenchant.aliases);
    }

    private int unenchant(CommandContext<CommandSourceStack> context) {
        String message;
        Enchantment enchantment;
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ItemStack item = player.getInventory().getItemInMainHand();
        int level = item.removeEnchantment(enchantment = (Enchantment)context.getArgument("enchantment", Enchantment.class));
        String string = message = level != 0 ? "command.enchantment.removed" : "command.enchantment.absent";
        if (Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK)) || level == 0) {
            int clamped = Math.clamp((long)level, enchantment.getStartLevel(), enchantment.getMaxLevel());
            this.plugin.bundle().sendMessage((Audience)player, message, new TagResolver[]{Placeholder.component((String)"enchantment", (ComponentLike)enchantment.displayName(clamped).style(Style.empty()))});
        }
        return level != 0 ? 1 : 0;
    }
}

