/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.adapter;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.kyori.adventure.key.Key;
import net.thenextlvl.tweaks.model.LazyLocation;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class LazyLocationAdapter
implements JsonSerializer<LazyLocation>,
JsonDeserializer<LazyLocation> {
    public @Nullable LazyLocation deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (!element.isJsonPrimitive()) {
            return null;
        }
        String[] split = element.getAsString().split(", ");
        Key world = Key.key((String)split[0]);
        double x = Double.parseDouble(split[1]);
        double y = Double.parseDouble(split[2]);
        double z = Double.parseDouble(split[3]);
        float yaw = split.length == 6 ? Float.parseFloat(split[4]) : 0.0f;
        float pitch = split.length == 6 ? Float.parseFloat(split[5]) : 0.0f;
        return new LazyLocation(world, x, y, z, yaw, pitch);
    }

    public JsonElement serialize(@Nullable LazyLocation source, Type type, JsonSerializationContext context) {
        if (source == null) {
            return JsonNull.INSTANCE;
        }
        StringBuilder builder = new StringBuilder(source.key().asString()).append(", ").append(source.getX()).append(", ").append(source.getY()).append(", ").append(source.getZ());
        if (source.getYaw() != 0.0f || source.getPitch() != 0.0f) {
            builder.append(", ").append(source.getYaw()).append(", ").append(source.getPitch());
        }
        return new JsonPrimitive(builder.toString());
    }
}

