/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.spawn;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.FinePositionResolver;
import io.papermc.paper.command.brigadier.argument.resolvers.RotationResolver;
import io.papermc.paper.math.FinePosition;
import io.papermc.paper.math.Rotation;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class SetSpawnCommand {
    private final TweaksPlugin plugin;

    public SetSpawnCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().setSpawn.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.setspawn"))).then(this.position())).executes(context -> {
            Location location = ((CommandSourceStack)context.getSource()).getLocation();
            return this.setSpawn((CommandContext<CommandSourceStack>)context, location.getWorld(), (FinePosition)location, Rotation.rotation((float)location.getYaw(), (float)location.getPitch()));
        })).build();
        registrar.register(command, "Set the spawn location", this.plugin.commands().setSpawn.aliases);
    }

    private RequiredArgumentBuilder<CommandSourceStack, FinePositionResolver> position() {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)ArgumentTypes.finePosition()).then(this.rotation())).executes(context -> {
            FinePositionResolver resolver = (FinePositionResolver)context.getArgument("position", FinePositionResolver.class);
            FinePosition position = (FinePosition)resolver.resolve((CommandSourceStack)context.getSource());
            World world = ((CommandSourceStack)context.getSource()).getLocation().getWorld();
            return this.setSpawn((CommandContext<CommandSourceStack>)context, world, position, Rotation.rotation((float)0.0f, (float)0.0f));
        });
    }

    private RequiredArgumentBuilder<CommandSourceStack, RotationResolver> rotation() {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"rotation", (ArgumentType)ArgumentTypes.rotation()).executes(context -> {
            RotationResolver rotation = (RotationResolver)context.getArgument("rotation", RotationResolver.class);
            FinePositionResolver resolver = (FinePositionResolver)context.getArgument("position", FinePositionResolver.class);
            FinePosition position = (FinePosition)resolver.resolve((CommandSourceStack)context.getSource());
            World world = ((CommandSourceStack)context.getSource()).getLocation().getWorld();
            return this.setSpawn((CommandContext<CommandSourceStack>)context, world, position, (Rotation)rotation.resolve((CommandSourceStack)context.getSource()));
        })).then(this.world());
    }

    private RequiredArgumentBuilder<CommandSourceStack, World> world() {
        return (RequiredArgumentBuilder)Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes(context -> {
            RotationResolver rotation = (RotationResolver)context.getArgument("rotation", RotationResolver.class);
            FinePositionResolver resolver = (FinePositionResolver)context.getArgument("position", FinePositionResolver.class);
            FinePosition position = (FinePosition)resolver.resolve((CommandSourceStack)context.getSource());
            World world = (World)context.getArgument("world", World.class);
            return this.setSpawn((CommandContext<CommandSourceStack>)context, world, position, (Rotation)rotation.resolve((CommandSourceStack)context.getSource()));
        });
    }

    private int setSpawn(CommandContext<CommandSourceStack> context, World world, FinePosition position, Rotation rotation) {
        CommandSender commandSender;
        Location spawn;
        this.plugin.config().spawn.location = spawn = position.toLocation(world).setRotation(rotation);
        this.plugin.saveConfig();
        if (Boolean.TRUE.equals(world.getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK))) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "command.spawn.set", new TagResolver[]{Placeholder.parsed((String)"world", (String)world.getName()), Formatter.number((String)"x", (Number)position.x()), Formatter.number((String)"y", (Number)position.y()), Formatter.number((String)"z", (Number)position.z()), Formatter.number((String)"yaw", (Number)Float.valueOf(rotation.yaw())), Formatter.number((String)"pitch", (Number)Float.valueOf(rotation.pitch()))});
        }
        if ((commandSender = ((CommandSourceStack)context.getSource()).getSender()) instanceof Player) {
            Player player = (Player)commandSender;
            player.teleportAsync(spawn, PlayerTeleportEvent.TeleportCause.COMMAND);
        }
        return 1;
    }
}

