/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.player;

import com.mojang.brigadier.tree.LiteralCommandNode;
import core.paper.item.ItemBuilder;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.IntStream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.player.PlayerCommand;
import net.thenextlvl.tweaks.model.PluginConfig;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class InventoryCommand
extends PlayerCommand
implements Listener {
    private final Map<HumanEntity, Player> viewers = new WeakHashMap<HumanEntity, Player>();
    private final Map<HumanEntity, ViewableInventory> viewables = new WeakHashMap<HumanEntity, ViewableInventory>();

    public InventoryCommand(TweaksPlugin plugin) {
        super(plugin);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = this.create(this.plugin.commands().inventory.command, "tweaks.command.inventory", "tweaks.command.inventory");
        registrar.register(command, "Open someone else's inventory", this.plugin.commands().inventory.aliases);
    }

    @Override
    protected int execute(CommandSender sender, Player target) {
        if (!(sender instanceof Player)) {
            this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
            return 0;
        }
        Player player = (Player)sender;
        if (sender.equals((Object)target)) {
            this.plugin.bundle().sendMessage((Audience)sender, "command.player.excluded", new TagResolver[]{Placeholder.parsed((String)"player", (String)sender.getName())});
            return 0;
        }
        ViewableInventory viewable = new ViewableInventory(player, target);
        player.openInventory(viewable.getInventory());
        this.viewables.put((HumanEntity)target, viewable);
        this.viewers.put((HumanEntity)player, target);
        return 1;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        this.viewables.remove(this.viewers.remove(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderInventoryClick(InventoryClickEvent event) {
        this.onProviderInventoryAction(event.getWhoClicked());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderInventoryCreative(InventoryCreativeEvent event) {
        this.onProviderInventoryAction(event.getWhoClicked());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderInventoryDrag(InventoryDragEvent event) {
        this.onProviderInventoryAction(event.getWhoClicked());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderItemDrop(PlayerDropItemEvent event) {
        this.onProviderInventoryAction((HumanEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderItemPickup(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof HumanEntity) {
            HumanEntity player = (HumanEntity)livingEntity;
            this.onProviderInventoryAction(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderArrowPickup(PlayerPickupArrowEvent event) {
        this.onProviderInventoryAction((HumanEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderSwapHandItems(PlayerSwapHandItemsEvent event) {
        this.onProviderInventoryAction((HumanEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderItemBreak(PlayerItemBreakEvent event) {
        this.onProviderInventoryAction((HumanEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderItemConsume(PlayerItemConsumeEvent event) {
        this.onProviderInventoryAction((HumanEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderItemDamage(PlayerItemDamageEvent event) {
        this.onProviderInventoryAction((HumanEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onProviderItemMend(PlayerItemMendEvent event) {
        this.onProviderInventoryAction((HumanEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onViewerInventoryClick(InventoryClickEvent event) {
        event.setCancelled(this.onViewerInventoryAction(event.getClickedInventory(), event.getView(), event.getWhoClicked(), event.getSlot()));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onViewerInventoryDrag(InventoryDragEvent event) {
        this.onViewerInventoryAction(event.getInventory(), event.getView(), event.getWhoClicked(), -1);
    }

    public void onProviderInventoryAction(HumanEntity provider) {
        ViewableInventory inventory = this.viewables.get(provider);
        if (inventory == null) {
            return;
        }
        provider.getScheduler().run((Plugin)this.plugin, task -> inventory.updateInventory(), inventory::close);
    }

    public boolean onViewerInventoryAction(@Nullable Inventory clicked, InventoryView view, HumanEntity viewer, int slot) {
        Player target = this.viewers.get(viewer);
        if (target == null) {
            return false;
        }
        if (!viewer.hasPermission("tweaks.command.inventory.edit")) {
            return true;
        }
        target.getScheduler().run((Plugin)this.plugin, task -> {
            IntStream.range(0, 36).forEach(i -> {
                ItemStack content = view.getTopInventory().getContents()[i];
                target.getInventory().setItem(i, content);
            });
            target.getInventory().setHelmet(view.getTopInventory().getItem(45));
            target.getInventory().setChestplate(view.getTopInventory().getItem(46));
            target.getInventory().setLeggings(view.getTopInventory().getItem(47));
            target.getInventory().setBoots(view.getTopInventory().getItem(48));
            target.getInventory().setItemInOffHand(view.getTopInventory().getItem(50));
            target.setItemOnCursor(view.getTopInventory().getItem(52));
        }, () -> ((HumanEntity)viewer).closeInventory());
        return view.getTopInventory().equals((Object)clicked) && (slot >= 36 && slot <= 44 || slot == 49 || slot == 51 || slot == 53);
    }

    private class ViewableInventory
    implements InventoryHolder {
        private final Player target;
        private final Inventory inventory;

        private ViewableInventory(Player viewer, Player target) {
            Component title = InventoryCommand.this.plugin.bundle().component("gui.inventory.title", (Audience)viewer, Argument.component((String)"player", (ComponentLike)target.name()));
            this.inventory = InventoryCommand.this.plugin.getServer().createInventory((InventoryHolder)this, 54, title);
            this.target = target;
            this.addPlaceholders(viewer);
            this.updateInventory();
        }

        public Inventory getInventory() {
            return this.inventory;
        }

        private void updateInventory() {
            PlayerInventory inventory = this.target.getInventory();
            for (int i = 0; i < inventory.getStorageContents().length; ++i) {
                this.inventory.setItem(i, inventory.getStorageContents()[i]);
            }
            this.inventory.setItem(45, inventory.getHelmet());
            this.inventory.setItem(46, inventory.getChestplate());
            this.inventory.setItem(47, inventory.getLeggings());
            this.inventory.setItem(48, inventory.getBoots());
            this.inventory.setItem(50, inventory.getItemInOffHand());
            this.inventory.setItem(52, this.target.getItemOnCursor());
        }

        private void addPlaceholders(Player viewer) {
            PluginConfig.GUIConfig.InventoryGUI inventoryConfig = InventoryCommand.this.plugin.config().guis.inventory;
            ItemStack placeholder = ItemBuilder.of(inventoryConfig.placeholder).hideTooltip().item();
            this.inventory.setItem(36, ItemBuilder.of(inventoryConfig.helmet).itemName(InventoryCommand.this.plugin.bundle().component("gui.placeholder.helmet", (Audience)viewer)).item());
            this.inventory.setItem(37, ItemBuilder.of(inventoryConfig.chestplate).itemName(InventoryCommand.this.plugin.bundle().component("gui.placeholder.chestplate", (Audience)viewer)).item());
            this.inventory.setItem(38, ItemBuilder.of(inventoryConfig.leggings).itemName(InventoryCommand.this.plugin.bundle().component("gui.placeholder.leggings", (Audience)viewer)).item());
            this.inventory.setItem(39, ItemBuilder.of(inventoryConfig.boots).itemName(InventoryCommand.this.plugin.bundle().component("gui.placeholder.boots", (Audience)viewer)).item());
            this.inventory.setItem(41, ItemBuilder.of(inventoryConfig.offHand).itemName(InventoryCommand.this.plugin.bundle().component("gui.placeholder.off-hand", (Audience)viewer)).item());
            this.inventory.setItem(43, ItemBuilder.of(inventoryConfig.cursor).itemName(InventoryCommand.this.plugin.bundle().component("gui.placeholder.cursor", (Audience)viewer)).item());
            IntStream.of(40, 42, 44, 49, 51, 53).forEach(i -> this.inventory.setItem(i, placeholder));
        }

        public void close() {
            this.inventory.close();
        }
    }
}

