/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.item;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.Arrays;
import net.kyori.adventure.audience.Audience;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.GameRule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class RepairCommand {
    private final TweaksPlugin plugin;

    public RepairCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().repair.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.repair");
        })).then(Commands.literal((String)"all").executes(this::repairAll))).executes(this::repair)).build();
        registrar.register(command, "repair your tools", this.plugin.commands().repair.aliases);
    }

    private int repair(CommandContext<CommandSourceStack> context) {
        String message;
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        PlayerInventory inventory = player.getInventory();
        if (inventory.getItemInMainHand().getType().isAir()) {
            this.plugin.bundle().sendMessage((Audience)player, "command.hold.item");
            return 0;
        }
        boolean success = this.repair(inventory.getItemInMainHand());
        String string = message = success ? "command.item.repaired.success" : "command.item.repaired.fail";
        if (Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK)) || !success) {
            this.plugin.bundle().sendMessage((Audience)player, message);
        }
        return success ? 1 : 0;
    }

    private int repairAll(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        PlayerInventory inventory = player.getInventory();
        Boolean success = Arrays.stream(inventory.getContents()).map(this::repair).reduce(false, Boolean::logicalOr);
        if (Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK)) || !success.booleanValue()) {
            this.plugin.bundle().sendMessage((Audience)player, success != false ? "command.item.repaired.all" : "command.item.repaired.none");
        }
        return success != false ? 1 : 0;
    }

    private boolean repair(@Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        Integer damage = (Integer)item.getData(DataComponentTypes.DAMAGE);
        if (damage == null || damage == 0) {
            return false;
        }
        item.resetData((DataComponentType)DataComponentTypes.DAMAGE);
        return true;
    }
}

