/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.item;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.util.HashMap;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.translation.Translatable;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.GameRule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ItemCommand {
    private final TweaksPlugin plugin;

    public ItemCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().item.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.item");
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"item", (ArgumentType)ArgumentTypes.itemStack()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3564)).executes(context -> this.item((CommandContext<CommandSourceStack>)context, (Integer)context.getArgument("amount", Integer.TYPE))))).executes(context -> this.item((CommandContext<CommandSourceStack>)context, 1)))).build();
        registrar.register(command, "Gives you an item of your choice", this.plugin.commands().item.aliases);
    }

    private int item(CommandContext<CommandSourceStack> context, int amount) {
        int min;
        HashMap leftover;
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ItemStack item = (ItemStack)context.getArgument("item", ItemStack.class);
        PlayerInventory inventory = player.getInventory();
        int added = 0;
        do {
            min = Math.min(amount, item.getMaxStackSize());
            item.setAmount(min);
            leftover = inventory.addItem(new ItemStack[]{item});
            int leftovers = leftover.values().stream().mapToInt(ItemStack::getAmount).sum();
            added += min - leftovers;
        } while (leftover.isEmpty() && (amount -= min) > 0);
        if (added == 0) {
            this.plugin.bundle().sendMessage((Audience)player, "command.inventory.full");
            return 0;
        }
        if (Boolean.TRUE.equals(player.getWorld().getGameRuleValue(GameRule.SEND_COMMAND_FEEDBACK))) {
            this.plugin.bundle().sendMessage((Audience)player, "command.item.received", new TagResolver[]{Formatter.number((String)"amount", (Number)added), Placeholder.component((String)"item", (ComponentLike)Component.translatable((Translatable)item).hoverEvent((HoverEventSource)item.asHoverEvent(showItem -> showItem)))});
        }
        return 1;
    }
}

