/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import core.paper.command.ComponentCommandExceptionType;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import org.bukkit.GameMode;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class GameModeArgumentType
implements CustomArgumentType<GameMode, String> {
    public GameMode parse(StringReader reader) throws CommandSyntaxException {
        String input = (String)this.getNativeType().parse(reader);
        return Arrays.stream(GameMode.values()).filter(gameMode -> gameMode.name().toLowerCase(Locale.ROOT).startsWith(input.toLowerCase(Locale.ROOT)) || input.equals(String.valueOf(gameMode.getValue()))).findAny().orElseThrow(() -> {
            TranslatableComponent gameMode = Component.translatable((String)"argument.gamemode.invalid", (ComponentLike[])new ComponentLike[]{() -> Component.text((String)input)});
            return new ComponentCommandExceptionType((Component)gameMode).createWithContext((ImmutableStringReader)reader);
        });
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Arrays.stream(GameMode.values()).map(gameMode -> gameMode.name().toLowerCase()).filter(name -> name.contains(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }
}

