/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks;

import com.google.gson.GsonBuilder;
import core.file.FileIO;
import core.file.format.GsonFile;
import core.i18n.file.ComponentBundle;
import core.io.IO;
import core.paper.adapters.inventory.MaterialAdapter;
import core.paper.adapters.world.LocationAdapter;
import core.paper.adapters.world.WorldAdapter;
import core.paper.messenger.PluginMessenger;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.net.URI;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.bstats.bukkit.Metrics;
import net.thenextlvl.tweaks.command.environment.time.DayCommand;
import net.thenextlvl.tweaks.command.environment.time.MidnightCommand;
import net.thenextlvl.tweaks.command.environment.time.NightCommand;
import net.thenextlvl.tweaks.command.environment.time.NoonCommand;
import net.thenextlvl.tweaks.command.environment.time.TimeCommand;
import net.thenextlvl.tweaks.command.environment.weather.RainCommand;
import net.thenextlvl.tweaks.command.environment.weather.SunCommand;
import net.thenextlvl.tweaks.command.environment.weather.ThunderCommand;
import net.thenextlvl.tweaks.command.environment.weather.WeatherCommand;
import net.thenextlvl.tweaks.command.home.DeleteHomeCommand;
import net.thenextlvl.tweaks.command.home.HomeCommand;
import net.thenextlvl.tweaks.command.home.HomesCommand;
import net.thenextlvl.tweaks.command.home.SetHomeCommand;
import net.thenextlvl.tweaks.command.item.EnchantCommand;
import net.thenextlvl.tweaks.command.item.HeadCommand;
import net.thenextlvl.tweaks.command.item.ItemCommand;
import net.thenextlvl.tweaks.command.item.LoreCommand;
import net.thenextlvl.tweaks.command.item.RenameCommand;
import net.thenextlvl.tweaks.command.item.RepairCommand;
import net.thenextlvl.tweaks.command.item.UnbreakableCommand;
import net.thenextlvl.tweaks.command.item.UnenchantCommand;
import net.thenextlvl.tweaks.command.message.MSGCommand;
import net.thenextlvl.tweaks.command.message.MSGToggleCommand;
import net.thenextlvl.tweaks.command.message.ReplyCommand;
import net.thenextlvl.tweaks.command.player.BackCommand;
import net.thenextlvl.tweaks.command.player.EnderChestCommand;
import net.thenextlvl.tweaks.command.player.FeedCommand;
import net.thenextlvl.tweaks.command.player.FlyCommand;
import net.thenextlvl.tweaks.command.player.GameModeCommand;
import net.thenextlvl.tweaks.command.player.GodCommand;
import net.thenextlvl.tweaks.command.player.HatCommand;
import net.thenextlvl.tweaks.command.player.HealCommand;
import net.thenextlvl.tweaks.command.player.InventoryCommand;
import net.thenextlvl.tweaks.command.player.OfflineTeleportCommand;
import net.thenextlvl.tweaks.command.player.PingCommand;
import net.thenextlvl.tweaks.command.player.SeenCommand;
import net.thenextlvl.tweaks.command.player.SpeedCommand;
import net.thenextlvl.tweaks.command.player.SuicideCommand;
import net.thenextlvl.tweaks.command.player.TrashCommand;
import net.thenextlvl.tweaks.command.player.VanishCommand;
import net.thenextlvl.tweaks.command.server.BroadcastCommand;
import net.thenextlvl.tweaks.command.server.LobbyCommand;
import net.thenextlvl.tweaks.command.server.MotdCommand;
import net.thenextlvl.tweaks.command.social.DiscordCommand;
import net.thenextlvl.tweaks.command.social.RedditCommand;
import net.thenextlvl.tweaks.command.social.TeamSpeakCommand;
import net.thenextlvl.tweaks.command.social.TikTokCommand;
import net.thenextlvl.tweaks.command.social.TwitchCommand;
import net.thenextlvl.tweaks.command.social.WebsiteCommand;
import net.thenextlvl.tweaks.command.social.XCommand;
import net.thenextlvl.tweaks.command.social.YouTubeCommand;
import net.thenextlvl.tweaks.command.spawn.SetSpawnCommand;
import net.thenextlvl.tweaks.command.spawn.SpawnCommand;
import net.thenextlvl.tweaks.command.tpa.TPADenyCommand;
import net.thenextlvl.tweaks.command.tpa.TPAHereCommand;
import net.thenextlvl.tweaks.command.tpa.TPAToggleCommand;
import net.thenextlvl.tweaks.command.tpa.TPAcceptCommand;
import net.thenextlvl.tweaks.command.tpa.TPAskCommand;
import net.thenextlvl.tweaks.command.warp.DeleteWarpCommand;
import net.thenextlvl.tweaks.command.warp.SetWarpCommand;
import net.thenextlvl.tweaks.command.warp.WarpCommand;
import net.thenextlvl.tweaks.command.warp.WarpsCommand;
import net.thenextlvl.tweaks.command.workstation.AnvilCommand;
import net.thenextlvl.tweaks.command.workstation.CartographyTableCommand;
import net.thenextlvl.tweaks.command.workstation.EnchantingTableCommand;
import net.thenextlvl.tweaks.command.workstation.GrindstoneCommand;
import net.thenextlvl.tweaks.command.workstation.LoomCommand;
import net.thenextlvl.tweaks.command.workstation.SmithingTableCommand;
import net.thenextlvl.tweaks.command.workstation.StonecutterCommand;
import net.thenextlvl.tweaks.command.workstation.WorkbenchCommand;
import net.thenextlvl.tweaks.controller.BackController;
import net.thenextlvl.tweaks.controller.DataController;
import net.thenextlvl.tweaks.controller.HomeController;
import net.thenextlvl.tweaks.controller.MSGController;
import net.thenextlvl.tweaks.controller.ServiceController;
import net.thenextlvl.tweaks.controller.TPAController;
import net.thenextlvl.tweaks.controller.TeleportController;
import net.thenextlvl.tweaks.controller.WarpController;
import net.thenextlvl.tweaks.listener.BackListener;
import net.thenextlvl.tweaks.listener.ChatListener;
import net.thenextlvl.tweaks.listener.ConnectionListener;
import net.thenextlvl.tweaks.listener.EntityListener;
import net.thenextlvl.tweaks.listener.SpawnListener;
import net.thenextlvl.tweaks.listener.WorldListener;
import net.thenextlvl.tweaks.model.CommandConfig;
import net.thenextlvl.tweaks.model.MessageMigrator;
import net.thenextlvl.tweaks.model.PluginConfig;
import net.thenextlvl.tweaks.version.PluginVersionChecker;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.ServerLinks;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class TweaksPlugin
extends JavaPlugin {
    private final Metrics metrics = new Metrics((Plugin)this, 19651);
    private final PluginMessenger messenger = new PluginMessenger((Plugin)this);
    private final PluginVersionChecker versionChecker = new PluginVersionChecker((Plugin)this);
    private final CommandConfig commands = (CommandConfig)new GsonFile<CommandConfig>((IO)IO.of(this.getDataFolder(), "commands.json"), new CommandConfig()).validate().save(new FileAttribute[0]).getRoot();
    private @Nullable ComponentBundle bundle;
    private @Nullable FileIO<PluginConfig> config;
    private @Nullable ServiceController serviceController;
    private final BackController backController = new BackController(this);
    private final DataController dataController = new DataController(this);
    private final HomeController homeController = new HomeController(this);
    private final MSGController msgController = new MSGController();
    private final TPAController tpaController = new TPAController(this);
    private final TeleportController teleportController = new TeleportController(this);
    private final WarpController warpController = new WarpController(this);

    public void onLoad() {
        this.versionChecker.checkVersion();
    }

    public void onEnable() {
        this.initConfig();
        this.initTranslations();
        this.initControllers();
        this.initMotd();
        this.registerCommands();
        this.registerLinks();
        this.registerListeners();
    }

    public void onDisable() {
        this.metrics.shutdown();
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new BackListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ConnectionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SpawnListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldListener(this), (Plugin)this);
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> {
            Commands registrar = (Commands)event.registrar();
            PluginConfig.FeatureConfig features = this.config().features;
            this.registerItemCommands(registrar);
            this.registerPlayerCommands(registrar);
            this.registerServerCommands(registrar);
            if (features.time) {
                this.registerTimeCommands(registrar);
            }
            if (features.weather) {
                this.registerWeatherCommands(registrar);
            }
            if (features.workstation) {
                this.registerWorkstationCommands(registrar);
            }
            if (features.homes) {
                this.registerHomeCommands(registrar);
            }
            if (features.msg) {
                this.registerMSGCommands(registrar);
            }
            if (features.spawn) {
                this.registerSpawnCommands(registrar);
            }
            if (features.tpa) {
                this.registerTpaCommands(registrar);
            }
            if (features.warps) {
                this.registerWarpCommands(registrar);
            }
            if (features.social.linkCommands) {
                this.registerLinkCommands(registrar);
            }
        }));
    }

    private void registerTimeCommands(Commands registrar) {
        if (this.commands().day.enabled) {
            new DayCommand(this).register(registrar);
        }
        if (this.commands().midnight.enabled) {
            new MidnightCommand(this).register(registrar);
        }
        if (this.commands().night.enabled) {
            new NightCommand(this).register(registrar);
        }
        if (this.commands().noon.enabled) {
            new NoonCommand(this).register(registrar);
        }
        if (this.commands().time.enabled) {
            new TimeCommand(this).register(registrar);
        }
    }

    private void registerWeatherCommands(Commands registrar) {
        if (this.commands().rain.enabled) {
            new RainCommand(this).register(registrar);
        }
        if (this.commands().sun.enabled) {
            new SunCommand(this).register(registrar);
        }
        if (this.commands().thunder.enabled) {
            new ThunderCommand(this).register(registrar);
        }
        if (this.commands().weather.enabled) {
            new WeatherCommand(this).register(registrar);
        }
    }

    private void registerItemCommands(Commands registrar) {
        if (this.commands().enchant.enabled) {
            new EnchantCommand(this).register(registrar);
        }
        if (this.commands().head.enabled) {
            new HeadCommand(this).register(registrar);
        }
        if (this.commands().item.enabled) {
            new ItemCommand(this).register(registrar);
        }
        if (this.commands().lore.enabled) {
            new LoreCommand(this).register(registrar);
        }
        if (this.commands().rename.enabled) {
            new RenameCommand(this).register(registrar);
        }
        if (this.commands().repair.enabled) {
            new RepairCommand(this).register(registrar);
        }
        if (this.commands().unbreakable.enabled) {
            new UnbreakableCommand(this).register(registrar);
        }
        if (this.commands().unenchant.enabled) {
            new UnenchantCommand(this).register(registrar);
        }
    }

    private void registerPlayerCommands(Commands registrar) {
        if (this.commands().back.enabled) {
            new BackCommand(this).register(registrar);
        }
        if (this.commands().enderchest.enabled) {
            new EnderChestCommand(this).register(registrar);
        }
        if (this.commands().feed.enabled) {
            new FeedCommand(this).register(registrar);
        }
        if (this.commands().fly.enabled) {
            new FlyCommand(this).register(registrar);
        }
        if (this.commands().gamemode.enabled) {
            new GameModeCommand(this).register(registrar);
        }
        if (this.commands().god.enabled) {
            new GodCommand(this).register(registrar);
        }
        if (this.commands().hat.enabled) {
            new HatCommand(this).register(registrar);
        }
        if (this.commands().heal.enabled) {
            new HealCommand(this).register(registrar);
        }
        if (this.commands().inventory.enabled) {
            new InventoryCommand(this).register(registrar);
        }
        if (this.commands().offlineTeleport.enabled) {
            new OfflineTeleportCommand(this).register(registrar);
        }
        if (this.commands().ping.enabled) {
            new PingCommand(this).register(registrar);
        }
        if (this.commands().seen.enabled) {
            new SeenCommand(this).register(registrar);
        }
        if (this.commands().speed.enabled) {
            new SpeedCommand(this).register(registrar);
        }
        if (this.commands().suicide.enabled) {
            new SuicideCommand(this).register(registrar);
        }
        if (this.commands().trash.enabled) {
            new TrashCommand(this).register(registrar);
        }
        if (this.commands().vanish.enabled) {
            new VanishCommand(this).register(registrar);
        }
    }

    private void registerServerCommands(Commands registrar) {
        if (this.commands().back.enabled) {
            new BroadcastCommand(this).register(registrar);
        }
        if (this.commands().lobby.enabled) {
            new LobbyCommand(this).register(registrar);
        }
        if (this.commands().motd.enabled) {
            new MotdCommand(this).register(registrar);
        }
    }

    private void registerWorkstationCommands(Commands registrar) {
        if (this.commands().anvil.enabled) {
            new AnvilCommand(this).register(registrar);
        }
        if (this.commands().cartographyTable.enabled) {
            new CartographyTableCommand(this).register(registrar);
        }
        if (this.commands().enchantingTable.enabled) {
            new EnchantingTableCommand(this).register(registrar);
        }
        if (this.commands().grindstone.enabled) {
            new GrindstoneCommand(this).register(registrar);
        }
        if (this.commands().loom.enabled) {
            new LoomCommand(this).register(registrar);
        }
        if (this.commands().smithingTable.enabled) {
            new SmithingTableCommand(this).register(registrar);
        }
        if (this.commands().stonecutter.enabled) {
            new StonecutterCommand(this).register(registrar);
        }
        if (this.commands().workbench.enabled) {
            new WorkbenchCommand(this).register(registrar);
        }
    }

    private void registerHomeCommands(Commands registrar) {
        if (this.commands().deleteHome.enabled) {
            new DeleteHomeCommand(this).register(registrar);
        }
        if (this.commands().home.enabled) {
            new HomeCommand(this).register(registrar);
        }
        if (this.commands().homes.enabled) {
            new HomesCommand(this).register(registrar);
        }
        if (this.commands().setHome.enabled) {
            new SetHomeCommand(this).register(registrar);
        }
    }

    private void registerMSGCommands(Commands registrar) {
        if (this.commands().msg.enabled) {
            new MSGCommand(this).register(registrar);
        }
        if (this.commands().msgToggle.enabled) {
            new MSGToggleCommand(this).register(registrar);
        }
        if (this.commands().reply.enabled) {
            new ReplyCommand(this).register(registrar);
        }
    }

    private void registerSpawnCommands(Commands registrar) {
        if (this.commands().setSpawn.enabled) {
            new SetSpawnCommand(this).register(registrar);
        }
        if (this.commands().spawn.enabled) {
            new SpawnCommand(this).register(registrar);
        }
    }

    private void registerTpaCommands(Commands registrar) {
        if (this.commands().teleportAccept.enabled) {
            new TPAcceptCommand(this).register(registrar);
        }
        if (this.commands().teleportAsk.enabled) {
            new TPAskCommand(this).register(registrar);
        }
        if (this.commands().teleportDeny.enabled) {
            new TPADenyCommand(this).register(registrar);
        }
        if (this.commands().teleportHere.enabled) {
            new TPAHereCommand(this).register(registrar);
        }
        if (this.commands().teleportToggle.enabled) {
            new TPAToggleCommand(this).register(registrar);
        }
    }

    private void registerWarpCommands(Commands registrar) {
        if (this.commands().deleteWarp.enabled) {
            new DeleteWarpCommand(this).register(registrar);
        }
        if (this.commands().setWarp.enabled) {
            new SetWarpCommand(this).register(registrar);
        }
        if (this.commands().warp.enabled) {
            new WarpCommand(this).register(registrar);
        }
        if (this.commands().warps.enabled) {
            new WarpsCommand(this).register(registrar);
        }
    }

    private void registerLinkCommands(Commands registrar) {
        if (this.commands().discord.enabled && this.isLinkEnabled("discord")) {
            new DiscordCommand(this).register(registrar);
        }
        if (this.commands().reddit.enabled && this.isLinkEnabled("reddit")) {
            new RedditCommand(this).register(registrar);
        }
        if (this.commands().teamspeak.enabled && this.isLinkEnabled("teamspeak")) {
            new TeamSpeakCommand(this).register(registrar);
        }
        if (this.commands().tiktok.enabled && this.isLinkEnabled("tiktok")) {
            new TikTokCommand(this).register(registrar);
        }
        if (this.commands().twitch.enabled && this.isLinkEnabled("twitch")) {
            new TwitchCommand(this).register(registrar);
        }
        if (this.commands().website.enabled && this.isLinkEnabled("website")) {
            new WebsiteCommand(this).register(registrar);
        }
        if (this.commands().x.enabled && this.isLinkEnabled("x")) {
            new XCommand(this).register(registrar);
        }
        if (this.commands().youtube.enabled && this.isLinkEnabled("youtube")) {
            new YouTubeCommand(this).register(registrar);
        }
    }

    private boolean isLinkEnabled(String string) {
        String url = this.config().links.get(string);
        return url != null && !url.isBlank() && !url.equals(PluginConfig.LINK_DEFAULTS.get(string));
    }

    private void registerLinks() {
        PluginConfig.FeatureConfig.SocialConfig social = this.config().features.social;
        if (!social.serverLinks) {
            return;
        }
        if (social.discord) {
            this.registerLink("url.discord", "discord");
        }
        if (social.reddit) {
            this.registerLink("url.reddit", "reddit");
        }
        if (social.teamspeak) {
            this.registerLink("url.teamspeak", "teamspeak");
        }
        if (social.tiktok) {
            this.registerLink("url.tiktok", "tiktok");
        }
        if (social.twitch) {
            this.registerLink("url.twitch", "twitch");
        }
        if (social.x) {
            this.registerLink("url.x", "x");
        }
        if (social.youtube) {
            this.registerLink("url.youtube", "youtube");
        }
        if (social.announcements) {
            this.registerLink(ServerLinks.Type.ANNOUNCEMENTS, "announcements");
        }
        if (social.community) {
            this.registerLink(ServerLinks.Type.COMMUNITY, "community");
        }
        if (social.feedback) {
            this.registerLink(ServerLinks.Type.FEEDBACK, "feedback");
        }
        if (social.forum) {
            this.registerLink(ServerLinks.Type.FORUMS, "forum");
        }
        if (social.guidelines) {
            this.registerLink(ServerLinks.Type.COMMUNITY_GUIDELINES, "guidelines");
        }
        if (social.issues) {
            this.registerLink(ServerLinks.Type.REPORT_BUG, "issues");
        }
        if (social.news) {
            this.registerLink(ServerLinks.Type.NEWS, "news");
        }
        if (social.status) {
            this.registerLink(ServerLinks.Type.STATUS, "status");
        }
        if (social.support) {
            this.registerLink(ServerLinks.Type.SUPPORT, "support");
        }
        if (social.website) {
            this.registerLink(ServerLinks.Type.WEBSITE, "website");
        }
        this.config().links.forEach((name, url) -> {
            if (url.isBlank() || PluginConfig.LINK_DEFAULTS.containsKey(name)) {
                return;
            }
            this.getServer().getServerLinks().addLink((Component)Component.text((String)name), URI.create(url));
        });
    }

    private void registerLink(ServerLinks.Type type, String string) {
        String url = this.config().links.get(string);
        if (url == null || url.isBlank() || url.equals(PluginConfig.LINK_DEFAULTS.get(string))) {
            return;
        }
        this.getServer().getServerLinks().addLink(type, URI.create(url));
    }

    private void registerLink(String translationKey, String string) {
        Component translation = this.bundle().translate(translationKey, Locale.US);
        if (translation == null) {
            return;
        }
        String url = this.config().links.get(string);
        if (url == null || url.isBlank() || url.equals(PluginConfig.LINK_DEFAULTS.get(string))) {
            return;
        }
        this.getServer().getServerLinks().addLink(translation, URI.create(url));
    }

    public void saveConfig() {
        if (this.config != null) {
            this.config.save(new FileAttribute[0]);
        }
    }

    private void initConfig() {
        this.config = new GsonFile<PluginConfig>((IO)IO.of(this.getDataFolder(), "config.json"), new PluginConfig(), new GsonBuilder().registerTypeHierarchyAdapter(Location.class, (Object)new LocationAdapter.Simple()).registerTypeHierarchyAdapter(Material.class, (Object)new MaterialAdapter()).registerTypeHierarchyAdapter(World.class, (Object)new WorldAdapter.Key()).disableHtmlEscaping().setPrettyPrinting().serializeNulls().create()).validate().save(new FileAttribute[0]);
    }

    private void initTranslations() {
        this.bundle = ComponentBundle.builder(Key.key((String)"tweaks", (String)"translations"), this.getDataPath().resolve("translations")).migrator(new MessageMigrator()).resource("tweaks.properties", Locale.US).resource("tweaks_german.properties", Locale.GERMANY).resource("tweaks_russian.properties", Locale.forLanguageTag("ru")).placeholder("prefix", "prefix").miniMessage(MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), Placeholder.parsed((String)"announcements", (String)String.valueOf(this.config().links.get("announcements"))), Placeholder.parsed((String)"community", (String)String.valueOf(this.config().links.get("community"))), Placeholder.parsed((String)"discord", (String)String.valueOf(this.config().links.get("discord"))), Placeholder.parsed((String)"feedback", (String)String.valueOf(this.config().links.get("feedback"))), Placeholder.parsed((String)"forum", (String)String.valueOf(this.config().links.get("forum"))), Placeholder.parsed((String)"guidelines", (String)String.valueOf(this.config().links.get("guidelines"))), Placeholder.parsed((String)"issues", (String)String.valueOf(this.config().links.get("issues"))), Placeholder.parsed((String)"news", (String)String.valueOf(this.config().links.get("news"))), Placeholder.parsed((String)"reddit", (String)String.valueOf(this.config().links.get("reddit"))), Placeholder.parsed((String)"status", (String)String.valueOf(this.config().links.get("status"))), Placeholder.parsed((String)"support", (String)String.valueOf(this.config().links.get("support"))), Placeholder.parsed((String)"teamspeak", (String)String.valueOf(this.config().links.get("teamspeak"))), Placeholder.parsed((String)"tiktok", (String)String.valueOf(this.config().links.get("tiktok"))), Placeholder.parsed((String)"twitch", (String)String.valueOf(this.config().links.get("twitch"))), Placeholder.parsed((String)"website", (String)String.valueOf(this.config().links.get("website"))), Placeholder.parsed((String)"x", (String)String.valueOf(this.config().links.get("x"))), Placeholder.parsed((String)"youtube", (String)String.valueOf(this.config().links.get("youtube")))})).build()).build();
    }

    private void initControllers() {
        if (this.getServer().getPluginManager().isPluginEnabled("ServiceIO")) {
            this.serviceController = new ServiceController(this);
        }
    }

    private void initMotd() {
        String motd = this.config().general.motd;
        if (motd != null) {
            this.getServer().motd(MiniMessage.miniMessage().deserialize((Object)motd));
        }
    }

    public PluginMessenger messenger() {
        return this.messenger;
    }

    public BackController backController() {
        return this.backController;
    }

    public DataController dataController() {
        return this.dataController;
    }

    public HomeController homeController() {
        return this.homeController;
    }

    public MSGController msgController() {
        return this.msgController;
    }

    public TPAController tpaController() {
        return this.tpaController;
    }

    public TeleportController teleportController() {
        return this.teleportController;
    }

    public WarpController warpController() {
        return this.warpController;
    }

    public CommandConfig commands() {
        return this.commands;
    }

    public ComponentBundle bundle() {
        return Objects.requireNonNull(this.bundle, "Bundle not initialized yet!");
    }

    public PluginConfig config() {
        return Objects.requireNonNull(this.config, "Config not initialized yet!").getRoot();
    }

    public @Nullable ServiceController serviceController() {
        return this.serviceController;
    }

    public TagResolver.Builder serviceResolvers(Player player) {
        TagResolver[] tagResolverArray = new TagResolver[19];
        tagResolverArray[0] = Placeholder.component((String)"custom_name", (ComponentLike)((ComponentLike)Optional.ofNullable(player.customName()).orElseGet(() -> ((Player)player).name())));
        tagResolverArray[1] = Placeholder.component((String)"display_name", (ComponentLike)player.displayName());
        tagResolverArray[2] = Placeholder.parsed((String)"balance", (String)"");
        tagResolverArray[3] = Placeholder.parsed((String)"balance_unformatted", (String)"");
        tagResolverArray[4] = Placeholder.parsed((String)"bank_balance", (String)"");
        tagResolverArray[5] = Placeholder.parsed((String)"bank_balance_unformatted", (String)"");
        tagResolverArray[6] = Placeholder.parsed((String)"chat_display_name", (String)player.getName());
        tagResolverArray[7] = Placeholder.parsed((String)"chat_prefix", (String)"");
        tagResolverArray[8] = Placeholder.parsed((String)"chat_suffix", (String)"");
        tagResolverArray[9] = Placeholder.parsed((String)"currency_name", (String)"");
        tagResolverArray[10] = Placeholder.parsed((String)"currency_name_plural", (String)"");
        tagResolverArray[11] = Placeholder.parsed((String)"currency_symbol", (String)"");
        tagResolverArray[12] = Placeholder.parsed((String)"group", (String)"");
        tagResolverArray[13] = Placeholder.parsed((String)"group_prefix", (String)"");
        tagResolverArray[14] = Placeholder.parsed((String)"group_suffix", (String)"");
        tagResolverArray[15] = Placeholder.parsed((String)"language_tag", (String)player.locale().toLanguageTag());
        tagResolverArray[16] = Placeholder.parsed((String)"locale", (String)player.locale().getDisplayName(player.locale()));
        tagResolverArray[17] = Placeholder.parsed((String)"player", (String)player.getName());
        tagResolverArray[18] = Placeholder.parsed((String)"world", (String)player.getWorld().getName());
        TagResolver.Builder resolver = TagResolver.builder().resolvers(tagResolverArray);
        if (this.serviceController == null) {
            return resolver;
        }
        return resolver.resolvers(new TagResolver[]{this.serviceController.serviceResolvers(player)});
    }
}

