/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.nbt.tag.impl;

import java.io.IOException;
import net.thenextlvl.nbt.NBTInputStream;
import net.thenextlvl.nbt.NBTOutputStream;
import net.thenextlvl.nbt.tag.StringTag;
import net.thenextlvl.nbt.tag.impl.ValueTagImpl;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class StringTagImpl
extends ValueTagImpl<String>
implements StringTag {
    public StringTagImpl(String value) {
        super(value);
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getAsString() {
        return (String)this.getValue();
    }

    @Override
    public int getTypeId() {
        return 8;
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        byte[] bytes = ((String)this.getValue()).getBytes(outputStream.getCharset());
        outputStream.writeShort(bytes.length);
        outputStream.write(bytes);
    }

    public static StringTagImpl read(NBTInputStream inputStream) throws IOException {
        short length = inputStream.readShort();
        byte[] bytes = new byte[length];
        inputStream.readFully(bytes);
        String value = new String(bytes, inputStream.getCharset());
        return new StringTagImpl(value);
    }
}

