/*
 * Decompiled with CFR 0.152.
 */
package core.paper.adapters.world;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import core.paper.adapters.api.PaperAdapter;
import java.lang.reflect.Type;
import org.bukkit.Location;
import org.bukkit.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class LocationAdapter {
    @Deprecated(forRemoval=true, since="2.0.1")
    public static Complex complex() {
        return new Complex();
    }

    @Deprecated(forRemoval=true, since="2.0.1")
    public static Complex.WorldLess complex(World world) {
        return new Complex.WorldLess(world);
    }

    @Deprecated(forRemoval=true, since="2.0.1")
    public static Simple simple() {
        return new Simple();
    }

    @Deprecated(forRemoval=true, since="2.0.1")
    public static Simple.WorldLess simple(World world) {
        return new Simple.WorldLess(world);
    }

    private static Location parseLocationData(JsonObject object, @Nullable World world) {
        double x = object.get("x").getAsDouble();
        double y = object.get("y").getAsDouble();
        double z = object.get("z").getAsDouble();
        float yaw = object.has("yaw") ? object.get("yaw").getAsFloat() : 0.0f;
        float pitch = object.has("pitch") ? object.get("pitch").getAsFloat() : 0.0f;
        return new Location(world, x, y, z, yaw, pitch);
    }

    private static JsonElement parseLocationData(Location source, JsonObject object) {
        object.addProperty("x", (Number)source.getX());
        object.addProperty("y", (Number)source.getY());
        object.addProperty("z", (Number)source.getZ());
        if (source.getYaw() != 0.0f || source.getPitch() != 0.0f) {
            return object;
        }
        object.addProperty("yaw", (Number)Float.valueOf(source.getYaw()));
        object.addProperty("pitch", (Number)Float.valueOf(source.getPitch()));
        return object;
    }

    public static final class Complex
    implements PaperAdapter<Location> {
        @Override
        public @Nullable Location deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (!element.isJsonObject()) {
                return null;
            }
            JsonObject object = element.getAsJsonObject();
            World world = (World)context.deserialize(object.get("world"), World.class);
            return LocationAdapter.parseLocationData(object, world);
        }

        @Override
        public JsonElement serialize(@Nullable Location source, Type type, JsonSerializationContext context) {
            if (source == null) {
                return JsonNull.INSTANCE;
            }
            JsonObject object = new JsonObject();
            object.add("world", context.serialize((Object)source.getWorld()));
            return LocationAdapter.parseLocationData(source, object);
        }

        public static final class WorldLess
        implements PaperAdapter<Location> {
            private final World world;

            public WorldLess(World world) {
                this.world = world;
            }

            @Override
            public @Nullable Location deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
                if (!element.isJsonObject()) {
                    return null;
                }
                return LocationAdapter.parseLocationData(element.getAsJsonObject(), this.world);
            }

            @Override
            public JsonElement serialize(@Nullable Location source, Type type, JsonSerializationContext context) {
                if (source == null) {
                    return JsonNull.INSTANCE;
                }
                return LocationAdapter.parseLocationData(source, new JsonObject());
            }
        }
    }

    public static final class Simple
    implements PaperAdapter<Location> {
        @Override
        public @Nullable Location deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (!element.isJsonPrimitive()) {
                return null;
            }
            String[] split = element.getAsString().split(", ");
            World world = (World)context.deserialize((JsonElement)new JsonPrimitive(split[0]), World.class);
            double x = Double.parseDouble(split[1]);
            double y = Double.parseDouble(split[2]);
            double z = Double.parseDouble(split[3]);
            float yaw = split.length == 6 ? Float.parseFloat(split[4]) : 0.0f;
            float pitch = split.length == 6 ? Float.parseFloat(split[5]) : 0.0f;
            return new Location(world, x, y, z, yaw, pitch);
        }

        @Override
        public JsonElement serialize(@Nullable Location source, Type type, JsonSerializationContext context) {
            if (source == null) {
                return JsonNull.INSTANCE;
            }
            String world = source.getWorld() != null ? context.serialize((Object)source.getWorld()).getAsString() : "null";
            StringBuilder builder = new StringBuilder(world).append(", ").append(source.getX()).append(", ").append(source.getY()).append(", ").append(source.getZ());
            if (source.getYaw() != 0.0f || source.getPitch() != 0.0f) {
                builder.append(", ").append(source.getYaw()).append(", ").append(source.getPitch());
            }
            return new JsonPrimitive(builder.toString());
        }

        public static final class WorldLess
        implements PaperAdapter<Location> {
            private final World world;

            public WorldLess(World world) {
                this.world = world;
            }

            @Override
            public @Nullable Location deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
                if (!element.isJsonPrimitive()) {
                    return null;
                }
                String[] split = element.getAsString().split(", ");
                double x = Double.parseDouble(split[0]);
                double y = Double.parseDouble(split[1]);
                double z = Double.parseDouble(split[2]);
                float yaw = split.length == 5 ? Float.parseFloat(split[3]) : 0.0f;
                float pitch = split.length == 5 ? Float.parseFloat(split[4]) : 0.0f;
                return new Location(this.world, x, y, z, yaw, pitch);
            }

            @Override
            public JsonElement serialize(@Nullable Location source, Type type, JsonSerializationContext context) {
                if (source == null) {
                    return JsonNull.INSTANCE;
                }
                StringBuilder builder = new StringBuilder().append(source.getX()).append(", ").append(source.getY()).append(", ").append(source.getZ());
                if (source.getYaw() != 0.0f || source.getPitch() != 0.0f) {
                    builder.append(", ").append(source.getYaw()).append(", ").append(source.getPitch());
                }
                return new JsonPrimitive(builder.toString());
            }
        }
    }
}

