/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.listener;

import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.MushroomCow;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SheepRegrowWoolEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class EntityListener
implements Listener {
    private final TweaksPlugin plugin;
    private final NamespacedKey mushroomCowStewCooldown = new NamespacedKey("tweaks", "mushroom_cow_stew_cooldown");
    private final NamespacedKey woolRegrowCooldown = new NamespacedKey("tweaks", "wool_regrow_cooldown");
    private final NamespacedKey cowMilkCooldown = new NamespacedKey("tweaks", "cow_milk_cooldown");

    public EntityListener(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onAnimalBreed(PlayerInteractEntityEvent event) {
        if (!this.plugin.config().vanilla.animalHealByFeeding) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Animals)) {
            return;
        }
        Animals animals = (Animals)entity;
        ItemStack item = event.getPlayer().getInventory().getItem(event.getHand());
        if (!animals.isBreedItem(item) || animals.isDead()) {
            return;
        }
        AttributeInstance attribute = animals.getAttribute(Attribute.MAX_HEALTH);
        if (attribute == null || animals.getHealth() == attribute.getValue()) {
            return;
        }
        animals.setHealth(Math.min(animals.getHealth() + 1.0, attribute.getValue()));
        GameMode gameMode = event.getPlayer().getGameMode();
        if (gameMode.equals((Object)GameMode.SURVIVAL) || gameMode.equals((Object)GameMode.ADVENTURE)) {
            item.subtract();
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSheepWoolRegrow(SheepRegrowWoolEvent event) {
        long cooldown = this.plugin.config().vanilla.sheepWoolGrowthCooldown;
        if (cooldown > 0L) {
            this.cooldown((Cancellable)event, (Entity)event.getEntity(), this.woolRegrowCooldown, cooldown);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCowMilk(PlayerInteractEntityEvent event) {
        ItemStack item = event.getPlayer().getInventory().getItem(event.getHand());
        if (!item.getType().equals((Object)Material.BUCKET)) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Cow)) {
            return;
        }
        Cow cow = (Cow)entity;
        long cooldown = this.plugin.config().vanilla.cowMilkingCooldown;
        if (cooldown > 0L) {
            this.cooldown((Cancellable)event, (Entity)cow, this.cowMilkCooldown, cooldown);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMushroomStew(PlayerInteractEntityEvent event) {
        ItemStack item = event.getPlayer().getInventory().getItem(event.getHand());
        if (!item.getType().equals((Object)Material.BOWL)) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof MushroomCow)) {
            return;
        }
        MushroomCow cow = (MushroomCow)entity;
        long cooldown = this.plugin.config().vanilla.mushroomStewCooldown;
        if (cooldown > 0L) {
            this.cooldown((Cancellable)event, (Entity)cow, this.mushroomCowStewCooldown, cooldown);
        }
    }

    private void cooldown(Cancellable cancellable, Entity entity, NamespacedKey key, long cooldown) {
        long now = System.currentTimeMillis();
        PersistentDataContainer container = entity.getPersistentDataContainer();
        Long data = (Long)container.get(key, PersistentDataType.LONG);
        if (data != null && now - data < cooldown) {
            cancellable.setCancelled(true);
        } else {
            container.set(key, PersistentDataType.LONG, (Object)now);
        }
    }
}

