/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.controller;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class TeleportController {
    private final Map<Player, Location> teleports = new WeakHashMap<Player, Location>();
    private final TweaksPlugin plugin;

    public TeleportController(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public CompletableFuture<Boolean> teleport(Player player, Location location, PlayerTeleportEvent.TeleportCause cause) {
        long cooldown = this.plugin.config().teleport.cooldown;
        if (cooldown <= 0L || player.hasPermission("tweaks.teleport.cooldown.bypass")) {
            return player.teleportAsync(location, cause);
        }
        if (location.equals((Object)this.teleports.put(player, location))) {
            return CompletableFuture.failedFuture(new IllegalStateException());
        }
        this.plugin.bundle().sendMessage((Audience)player, this.plugin.config().teleport.allowMovement ? "command.teleport.cooldown" : "command.teleport.cooldown.movement", Formatter.number((String)"time", (Number)((double)cooldown / 1000.0)));
        return this.scheduleTeleport(player, location, cause);
    }

    private CompletableFuture<Boolean> scheduleTeleport(Player player, Location location, PlayerTeleportEvent.TeleportCause cause) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                boolean blockMovements;
                Location previous = player.getLocation();
                long cooldown = this.plugin.config().teleport.cooldown;
                long teleportTime = System.currentTimeMillis() + cooldown;
                boolean bl = blockMovements = !this.plugin.config().teleport.allowMovement;
                while (System.currentTimeMillis() < teleportTime) {
                    if (blockMovements && !player.getWorld().equals((Object)previous.getWorld())) {
                        Boolean bl2 = false;
                        return bl2;
                    }
                    if (blockMovements && player.getLocation().distanceSquared(previous) > 0.2) {
                        Boolean bl3 = false;
                        return bl3;
                    }
                    Preconditions.checkState((boolean)player.isConnected());
                    Preconditions.checkState((boolean)location.equals((Object)this.teleports.getOrDefault(player, location)));
                    Thread.sleep(Math.min(50L, teleportTime - System.currentTimeMillis()));
                }
                Boolean bl4 = true;
                return bl4;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.teleports.remove(player);
            }
        }).thenCompose(success -> {
            if (success.booleanValue()) {
                return player.teleportAsync(location, cause);
            }
            return CompletableFuture.completedFuture(false);
        });
    }

    public void remove(Player player) {
        this.teleports.remove(player);
    }
}

