/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.controller;

import java.util.Optional;
import java.util.function.Function;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.service.api.chat.ChatController;
import net.thenextlvl.service.api.economy.EconomyController;
import net.thenextlvl.service.api.economy.bank.BankController;
import net.thenextlvl.service.api.group.GroupController;
import net.thenextlvl.service.api.group.GroupHolder;
import net.thenextlvl.service.api.permission.PermissionController;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ServiceController {
    private final @Nullable BankController banks;
    private final @Nullable ChatController chat;
    private final @Nullable EconomyController economy;
    private final @Nullable GroupController groups;
    private final @Nullable PermissionController permissions;

    public ServiceController(TweaksPlugin plugin) {
        this.banks = this.loadController(plugin, BankController.class, BankController::getName, "bank");
        this.chat = this.loadController(plugin, ChatController.class, ChatController::getName, "chat");
        this.economy = this.loadController(plugin, EconomyController.class, EconomyController::getName, "economy");
        this.groups = this.loadController(plugin, GroupController.class, GroupController::getName, "group");
        this.permissions = this.loadController(plugin, PermissionController.class, PermissionController::getName, "permission");
    }

    private <C> @Nullable C loadController(TweaksPlugin plugin, Class<C> clazz, Function<C, String> name, String description) {
        Object controller = plugin.getServer().getServicesManager().load(clazz);
        if (controller != null) {
            plugin.getComponentLogger().info("Using {} as {} provider", (Object)name.apply(controller), (Object)description);
        }
        return (C)controller;
    }

    public TagResolver serviceResolvers(Player player) {
        TagResolver.Builder builder = TagResolver.builder();
        Optional.ofNullable(this.getGroups()).flatMap(groups -> groups.getGroupHolder((OfflinePlayer)player).map(GroupHolder::getPrimaryGroup).flatMap(arg_0 -> ((GroupController)groups).getGroup(arg_0))).ifPresent(group -> {
            builder.resolver((TagResolver)Placeholder.parsed((String)"group", (String)group.getDisplayName().orElse(group.getName())));
            group.getPrefix().ifPresent(prefix -> builder.resolver((TagResolver)Placeholder.parsed((String)"group_prefix", (String)prefix)));
            group.getSuffix().ifPresent(suffix -> builder.resolver((TagResolver)Placeholder.parsed((String)"group_suffix", (String)suffix)));
        });
        Optional.ofNullable(this.getChat()).flatMap(chat -> chat.getProfile((OfflinePlayer)player)).ifPresent(profile -> {
            builder.resolver((TagResolver)Placeholder.parsed((String)"chat_display_name", (String)profile.getDisplayName().orElse(player.getName())));
            profile.getPrefix().ifPresent(prefix -> builder.resolver((TagResolver)Placeholder.parsed((String)"chat_prefix", (String)prefix)));
            profile.getSuffix().ifPresent(suffix -> builder.resolver((TagResolver)Placeholder.parsed((String)"chat_suffix", (String)suffix)));
        });
        Optional.ofNullable(this.getEconomy()).ifPresent(economy -> {
            economy.getAccount((OfflinePlayer)player).ifPresent(account -> {
                builder.resolver((TagResolver)Placeholder.parsed((String)"balance", (String)economy.format((Number)account.getBalance())));
                builder.resolver((TagResolver)Placeholder.parsed((String)"balance_unformatted", (String)account.getBalance().toString()));
            });
            Optional.ofNullable(this.banks).flatMap(controller -> controller.getBank((OfflinePlayer)player)).ifPresent(bank -> {
                builder.resolver((TagResolver)Placeholder.parsed((String)"bank_balance", (String)bank.getBalance().toString()));
                builder.resolver((TagResolver)Placeholder.parsed((String)"bank_balance_unformatted", (String)bank.getBalance().toString()));
            });
            builder.resolver((TagResolver)Placeholder.parsed((String)"currency_name", (String)economy.getCurrencyNameSingular(player.locale())));
            builder.resolver((TagResolver)Placeholder.parsed((String)"currency_name_plural", (String)economy.getCurrencyNamePlural(player.locale())));
            builder.resolver((TagResolver)Placeholder.parsed((String)"currency_symbol", (String)economy.getCurrencySymbol()));
        });
        return builder.build();
    }

    public int getChatDeleteWeight(Player player) {
        return Optional.ofNullable(this.getPermissions()).flatMap(controller -> controller.getPermissionHolder((OfflinePlayer)player)).flatMap(holder -> holder.intInfoNode("chat-delete-weight")).orElse(-1);
    }

    public int getWeight(Player player) {
        return Optional.ofNullable(this.getGroups()).flatMap(controller -> controller.getGroupHolder((OfflinePlayer)player).map(GroupHolder::getPrimaryGroup).flatMap(arg_0 -> ((GroupController)controller).getGroup(arg_0))).map(group -> group.getWeight().orElse(0)).orElse(0);
    }

    public @Nullable BankController getBanks() {
        return this.banks;
    }

    public @Nullable ChatController getChat() {
        return this.chat;
    }

    public @Nullable EconomyController getEconomy() {
        return this.economy;
    }

    public @Nullable GroupController getGroups() {
        return this.groups;
    }

    public @Nullable PermissionController getPermissions() {
        return this.permissions;
    }
}

