/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.controller;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.controller.ServiceController;
import net.thenextlvl.tweaks.model.NamedLocation;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class HomeController {
    private final TweaksPlugin plugin;

    public HomeController(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public CompletableFuture<Optional<Location>> getHome(OfflinePlayer player, String name) {
        return CompletableFuture.supplyAsync(() -> this.plugin.dataController().getHome(player, name)).exceptionally(throwable -> Optional.empty());
    }

    public CompletableFuture<Set<NamedLocation>> getHomes(OfflinePlayer player) {
        return CompletableFuture.supplyAsync(() -> this.plugin.dataController().getHomes(player)).exceptionally(throwable -> Set.of());
    }

    public CompletableFuture<Boolean> deleteHome(OfflinePlayer player, String name) {
        return CompletableFuture.supplyAsync(() -> this.plugin.dataController().deleteHome(player, name)).exceptionally(throwable -> false);
    }

    public int getMaxHomeCount(Player player) {
        return Optional.ofNullable(this.plugin.serviceController()).map(ServiceController::getPermissions).flatMap(controller -> controller.getPermissionHolder((OfflinePlayer)player)).flatMap(permissionHolder -> permissionHolder.intInfoNode("max-homes")).orElse(this.plugin.config().homes.limit);
    }
}

