/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.controller;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BackController {
    private final Map<Player, BlockingDeque<Location>> positions = new WeakHashMap<Player, BlockingDeque<Location>>();
    private final Map<Player, Location> positionLock = new WeakHashMap<Player, Location>();
    private final TweaksPlugin plugin;

    public BackController(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public @Nullable Location peekFirst(Player player) {
        BlockingDeque<Location> deque = this.positions.get(player);
        if (deque == null) {
            return null;
        }
        deque.removeIf(location -> !location.isWorldLoaded());
        return (Location)deque.peekFirst();
    }

    public void offerFirst(Player player, Location location) {
        this.positions.computeIfAbsent(player, ignored -> new LinkedBlockingDeque(this.plugin.config().general.backBufferStackSize)).offerFirst(location);
    }

    public void remove(Player player, Location location) {
        this.positions.computeIfPresent(player, (ignored, locations) -> locations.remove(location) && locations.isEmpty() ? null : locations);
    }

    public void remove(Player player) {
        this.positionLock.remove(player);
        this.positions.remove(player);
    }

    public @Nullable Location getLock(Player player) {
        return this.positionLock.get(player);
    }

    public void lock(Player player, Location location) {
        this.positionLock.put(player, location);
    }

    public void unlock(Player player) {
        this.positionLock.remove(player);
    }
}

