/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.tpa;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import core.paper.command.CustomArgumentTypes;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.RequestSuggestionProvider;
import net.thenextlvl.tweaks.controller.TPAController;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class TPADenyCommand {
    private final TweaksPlugin plugin;

    public TPADenyCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands commands) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().teleportDeny.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.tpa.deny");
        })).then(Commands.argument((String)"player", CustomArgumentTypes.playerExact()).suggests((SuggestionProvider)new RequestSuggestionProvider(this.plugin)).executes(context -> {
            Player sender = (Player)((CommandSourceStack)context.getSource()).getSender();
            Player target = (Player)context.getArgument("player", Player.class);
            Optional<TPAController.Request> type = this.plugin.tpaController().getRequest(sender, target);
            return TPADenyCommand.deny(this.plugin, sender, target, type.map(TPAController.Request::type).orElse(TPAController.RequestType.TPA));
        }))).executes(context -> {
            Player sender = (Player)((CommandSourceStack)context.getSource()).getSender();
            List<TPAController.Request> requests = this.plugin.tpaController().getRequests(sender);
            TPAController.Request request = requests.isEmpty() ? null : requests.getFirst();
            return TPADenyCommand.deny(this.plugin, sender, request != null ? request.player() : null, request != null ? request.type() : TPAController.RequestType.TPA);
        })).build();
        commands.register(command, "Deny a teleport request", this.plugin.commands().teleportDeny.aliases);
    }

    static int deny(TweaksPlugin plugin, Player sender, @Nullable Player player, TPAController.RequestType type) {
        boolean success;
        boolean bl = success = player != null && plugin.tpaController().removeRequest(sender, player, type);
        String message = player != null && success ? "command.tpa.denied.self" : (player != null ? "command.tpa.no-request" : "command.tpa.no-requests");
        plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"player", (String)(player != null ? player.getName() : "null"))});
        if (player != null && success) {
            plugin.bundle().sendMessage((Audience)player, "command.tpa.denied", new TagResolver[]{Placeholder.parsed((String)"player", (String)sender.getName())});
        }
        return player != null ? 1 : 0;
    }
}

