/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.player;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class SpeedCommand {
    private final TweaksPlugin plugin;
    private static final NamespacedKey SPEED_KEY = new NamespacedKey("tweaks", "speed");

    public SpeedCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().speed.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.speed"))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"speed", (ArgumentType)IntegerArgumentType.integer((int)-10, (int)10)).then(this.speed("fly", SpeedType.FLY))).then(this.speed("sneak", SpeedType.SNEAK))).then(this.speed("walk", SpeedType.WALK))).executes(context -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            if (sender instanceof Player) {
                Player player = (Player)sender;
                SpeedType type = player.isFlying() ? SpeedType.FLY : SpeedType.WALK;
                return this.speed((CommandContext<CommandSourceStack>)context, type, new ArrayList<Player>(List.of(player)));
            }
            this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reset").then(this.reset("fly", SpeedType.FLY))).then(this.reset("sneak", SpeedType.SNEAK))).then(this.reset("walk", SpeedType.WALK))).executes(context -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            if (sender instanceof Player) {
                Player player = (Player)sender;
                SpeedType type = player.isFlying() ? SpeedType.FLY : SpeedType.WALK;
                return this.reset((CommandContext<CommandSourceStack>)context, type, new ArrayList<Player>(List.of(player)));
            }
            this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
            return 0;
        }))).build();
        registrar.register(command, "Change your own or others fly, sneak or walk speed", this.plugin.commands().speed.aliases);
    }

    private LiteralArgumentBuilder<CommandSourceStack> reset(String literal, SpeedType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)literal).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)ArgumentTypes.entities()).requires(stack -> stack.getSender().hasPermission("tweaks.command.speed.others"))).executes(context -> {
            EntitySelectorArgumentResolver resolver = (EntitySelectorArgumentResolver)context.getArgument("targets", EntitySelectorArgumentResolver.class);
            return this.reset((CommandContext<CommandSourceStack>)context, type, new ArrayList<Entity>((Collection)resolver.resolve((CommandSourceStack)context.getSource())));
        }))).executes(context -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            if (sender instanceof Player) {
                Player player = (Player)sender;
                return this.reset((CommandContext<CommandSourceStack>)context, type, new ArrayList<Player>(List.of(player)));
            }
            this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
            return 0;
        });
    }

    private LiteralArgumentBuilder<CommandSourceStack> speed(String literal, SpeedType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)literal).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)ArgumentTypes.entities()).requires(stack -> stack.getSender().hasPermission("tweaks.command.speed.others"))).executes(context -> {
            EntitySelectorArgumentResolver resolver = (EntitySelectorArgumentResolver)context.getArgument("targets", EntitySelectorArgumentResolver.class);
            return this.speed((CommandContext<CommandSourceStack>)context, type, new ArrayList<Entity>((Collection)resolver.resolve((CommandSourceStack)context.getSource())));
        }))).executes(context -> {
            CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
            if (sender instanceof Player) {
                Player player = (Player)sender;
                return this.speed((CommandContext<CommandSourceStack>)context, type, new ArrayList<Player>(List.of(player)));
            }
            this.plugin.bundle().sendMessage((Audience)sender, "command.sender");
            return 0;
        });
    }

    private int reset(CommandContext<CommandSourceStack> context, SpeedType type, List<Entity> entities) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        entities.removeIf(entity -> !(entity instanceof Attributable));
        entities.forEach(entity -> {
            AttributeInstance instance = ((Attributable)entity).getAttribute(type.getAttribute());
            if (instance != null) {
                instance.removeModifier((Key)SPEED_KEY);
            }
            if (!type.equals((Object)SpeedType.SNEAK) && entity instanceof Player) {
                Player player = (Player)entity;
                if (type.equals((Object)SpeedType.FLY)) {
                    player.setFlySpeed(0.1f);
                }
                if (type.equals((Object)SpeedType.WALK)) {
                    player.setWalkSpeed(0.2f);
                }
            }
            this.plugin.bundle().sendMessage((Audience)entity, "command.speed.reset.self");
            if (!entity.equals((Object)sender)) {
                this.plugin.bundle().sendMessage((Audience)sender, "command.speed.reset.others", new TagResolver[]{Placeholder.component((String)"entity", (ComponentLike)entity.name().hoverEvent((HoverEventSource)entity.asHoverEvent()))});
            }
        });
        return 1;
    }

    private int speed(CommandContext<CommandSourceStack> context, SpeedType type, List<Entity> entities) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        double speed = (double)((Integer)context.getArgument("speed", Integer.TYPE)).intValue() / 10.0;
        entities.removeIf(entity -> !(entity instanceof Attributable));
        entities.forEach(entity -> {
            if (!type.equals((Object)SpeedType.SNEAK) && entity instanceof Player) {
                Player player = (Player)entity;
                if (type.equals((Object)SpeedType.FLY)) {
                    player.setFlySpeed((float)speed);
                }
                if (type.equals((Object)SpeedType.WALK)) {
                    player.setWalkSpeed((float)speed);
                }
            } else {
                AttributeInstance instance = ((Attributable)entity).getAttribute(type.getAttribute());
                if (instance != null) {
                    instance.removeModifier((Key)SPEED_KEY);
                    double value = speed - instance.getBaseValue();
                    AttributeModifier modifier = new AttributeModifier(SPEED_KEY, value, AttributeModifier.Operation.ADD_NUMBER);
                    instance.addTransientModifier(modifier);
                }
            }
            this.plugin.bundle().sendMessage((Audience)entity, type.getMessageSelf(), new TagResolver[]{Placeholder.parsed((String)"speed", (String)String.valueOf(speed))});
            if (!entity.equals((Object)sender)) {
                this.plugin.bundle().sendMessage((Audience)sender, type.getMessageOther(), new TagResolver[]{Placeholder.parsed((String)"speed", (String)String.valueOf(speed)), Placeholder.component((String)"entity", (ComponentLike)entity.name().hoverEvent((HoverEventSource)entity.asHoverEvent()))});
            }
        });
        return 1;
    }

    private static enum SpeedType {
        FLY(Attribute.FLYING_SPEED, "command.speed.fly.changed.others", "command.speed.fly.changed.self"),
        SNEAK(Attribute.SNEAKING_SPEED, "command.speed.sneak.changed.others", "command.speed.sneak.changed.self"),
        WALK(Attribute.MOVEMENT_SPEED, "command.speed.walk.changed.others", "command.speed.walk.changed.self");

        private final Attribute attribute;
        private final String messageOther;
        private final String messageSelf;

        private SpeedType(Attribute attribute, String messageOther, String messageSelf) {
            this.attribute = attribute;
            this.messageOther = messageOther;
            this.messageSelf = messageSelf;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public String getMessageOther() {
            return this.messageOther;
        }

        public String getMessageSelf() {
            return this.messageSelf;
        }
    }
}

