/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.player;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import core.io.IO;
import core.io.PathIO;
import core.nbt.file.NBTFile;
import core.nbt.tag.CompoundTag;
import core.nbt.tag.DoubleTag;
import core.nbt.tag.FloatTag;
import core.nbt.tag.ListTag;
import core.nbt.tag.Tag;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.OfflinePlayerSuggestionProvider;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class OfflineTeleportCommand {
    private final TweaksPlugin plugin;

    public OfflineTeleportCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().offlineTeleport.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.offline-tp"))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new OfflinePlayerSuggestionProvider(this.plugin)).then(Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new OfflinePlayerSuggestionProvider(this.plugin)).executes(context -> {
            this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.teleportOther((CommandContext<CommandSourceStack>)context));
            return 1;
        }))).executes(context -> {
            this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, task -> this.teleport((CommandContext<CommandSourceStack>)context));
            return 1;
        }))).build();
        registrar.register(command, "Teleport offline-players to others or you to them", this.plugin.commands().offlineTeleport.aliases);
    }

    private void teleportOther(CommandContext<CommandSourceStack> context) {
        OfflinePlayer target;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer((String)context.getArgument("player", String.class));
        String message = player.equals((Object)(target = this.plugin.getServer().getOfflinePlayer((String)context.getArgument("target", String.class)))) ? "command.offline.teleport.location" : this.teleport(player, target);
        this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{Placeholder.parsed((String)"source", (String)String.valueOf(player.getName())), Placeholder.parsed((String)"target", (String)String.valueOf(target.getName()))});
    }

    private void teleport(CommandContext<CommandSourceStack> context) {
        CommandSender commandSender = ((CommandSourceStack)context.getSource()).getSender();
        if (!(commandSender instanceof Player)) {
            this.plugin.bundle().sendMessage((Audience)((CommandSourceStack)context.getSource()).getSender(), "command.sender");
            return;
        }
        Player sender = (Player)commandSender;
        OfflinePlayer player = this.plugin.getServer().getOfflinePlayer((String)context.getArgument("player", String.class));
        TagResolver.Single placeholder = Placeholder.parsed((String)"player", (String)String.valueOf(player.getName()));
        ((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(this.getLocation(player)).thenCompose(location -> {
            if (location != null) {
                return sender.teleportAsync(location, PlayerTeleportEvent.TeleportCause.COMMAND);
            }
            return CompletableFuture.completedFuture(false);
        })).thenAccept(success -> {
            String message = success != false ? "command.offline.teleport.success.to" : "command.offline.teleport.fail.to";
            this.plugin.bundle().sendMessage((Audience)sender, message, new TagResolver[]{placeholder});
        })).exceptionally(throwable -> {
            this.plugin.bundle().sendMessage((Audience)sender, "command.offline.teleport.fail.to", new TagResolver[]{placeholder});
            this.plugin.getComponentLogger().error("Failed to teleport to offline player", throwable);
            return null;
        });
    }

    private String teleport(OfflinePlayer source, OfflinePlayer target) {
        Player online = source.getPlayer();
        Location location = this.getLocation(target);
        if (location == null) {
            return "command.offline.teleport.fail";
        }
        if (online == null) {
            return this.setLocation(source, location) ? "command.offline.teleport.success" : "command.offline.teleport.fail";
        }
        if (online.getLocation().equals((Object)location)) {
            return "command.offline.teleport.location";
        }
        online.teleportAsync(location, PlayerTeleportEvent.TeleportCause.COMMAND);
        return "command.offline.teleport.success";
    }

    private boolean setLocation(OfflinePlayer player, Location location) {
        NBTFile<CompoundTag> file = this.getNBTFile(player);
        if (file == null) {
            return false;
        }
        ((CompoundTag)file.getRoot()).addAll(this.toTag(location));
        file.save(new FileAttribute[0]);
        return true;
    }

    private @Nullable Location fromTag(CompoundTag tag) {
        World world = this.getWorld(tag);
        if (world == null) {
            return null;
        }
        ListTag pos = tag.getAsList("Pos");
        double z = ((DoubleTag)pos.get(2)).getAsDouble();
        double y = ((DoubleTag)pos.get(1)).getAsDouble();
        double x = ((DoubleTag)pos.get(0)).getAsDouble();
        ListTag rotation = tag.getAsList("Rotation");
        float yaw = ((FloatTag)rotation.get(0)).getAsFloat();
        float pitch = ((FloatTag)rotation.get(1)).getAsFloat();
        return new Location(world, x, y, z, yaw, pitch);
    }

    private @Nullable World getWorld(CompoundTag tag) {
        Optional<Long> uuidLeast = tag.optional("WorldUUIDLeast").map(Tag::getAsLong);
        if (uuidLeast.isEmpty()) {
            return null;
        }
        Optional<Long> uuidMost = tag.optional("WorldUUIDMost").map(Tag::getAsLong);
        if (uuidMost.isEmpty()) {
            return null;
        }
        World world = Bukkit.getWorld((UUID)new UUID(uuidLeast.get(), uuidMost.get()));
        if (world != null) {
            return world;
        }
        Optional<String> dimension = tag.optional("Dimension").map(Tag::getAsString);
        Optional<NamespacedKey> key = dimension.map(NamespacedKey::fromString);
        return key.map(Bukkit::getWorld).orElse(null);
    }

    private CompoundTag toTag(Location location) {
        ListTag<DoubleTag> pos = new ListTag<DoubleTag>(6);
        pos.add(new DoubleTag(location.getX()));
        pos.add(new DoubleTag(location.getY()));
        pos.add(new DoubleTag(location.getZ()));
        ListTag<FloatTag> rotation = new ListTag<FloatTag>(5);
        rotation.add(new FloatTag(Float.valueOf(location.getYaw())));
        rotation.add(new FloatTag(Float.valueOf(location.getPitch())));
        CompoundTag tag = new CompoundTag();
        tag.add("WorldUUIDLeast", location.getWorld().getUID().getLeastSignificantBits());
        tag.add("WorldUUIDMost", location.getWorld().getUID().getMostSignificantBits());
        tag.add("Dimension", location.getWorld().key().asString());
        tag.add("Pos", pos);
        tag.add("Rotation", rotation);
        return tag;
    }

    private @Nullable Location getLocation(OfflinePlayer player) {
        Player online = player.getPlayer();
        if (online != null) {
            return online.getLocation();
        }
        NBTFile<CompoundTag> file = this.getNBTFile(player);
        return file != null ? this.fromTag((CompoundTag)file.getRoot()) : null;
    }

    private @Nullable NBTFile<CompoundTag> getNBTFile(OfflinePlayer player) {
        World overworld = this.plugin.getServer().getWorld(Key.key((String)"overworld"));
        if (overworld == null) {
            return null;
        }
        File data = new File(overworld.getWorldFolder(), "playerdata");
        PathIO io = IO.of(data, String.valueOf(player.getUniqueId()) + ".dat");
        PathIO fallback = IO.of(data, String.valueOf(player.getUniqueId()) + ".dat_old");
        return io.exists(new LinkOption[0]) ? new NBTFile<CompoundTag>((IO)io, new CompoundTag()) : (fallback.exists(new LinkOption[0]) ? new NBTFile<CompoundTag>((IO)fallback, new CompoundTag()) : null);
    }
}

