/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.message;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import core.paper.command.CustomArgumentTypes;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.MSGSuggestionProvider;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class MSGCommand {
    private final TweaksPlugin plugin;

    public MSGCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands commands) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().msg.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.msg"))).then(Commands.argument((String)"player", CustomArgumentTypes.playerExact()).suggests((SuggestionProvider)new MSGSuggestionProvider(this.plugin)).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(this::message)))).build();
        commands.register(command, "Send a private message to a player", this.plugin.commands().msg.aliases);
    }

    private int message(CommandContext<CommandSourceStack> context) {
        Player target;
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (sender.equals((Object)(target = (Player)context.getArgument("player", Player.class)))) {
            this.plugin.bundle().sendMessage((Audience)sender, "command.msg.self");
            return 0;
        }
        if (!this.plugin.msgController().isConversing(sender, (CommandSender)target) && this.plugin.dataController().isMsgToggled((OfflinePlayer)target)) {
            this.plugin.bundle().sendMessage((Audience)sender, "command.msg.toggled", new TagResolver[]{Placeholder.parsed((String)"player", (String)target.getName())});
            return 0;
        }
        MSGCommand.message(this.plugin, context, sender, (CommandSender)target);
        return 1;
    }

    static void message(TweaksPlugin plugin, CommandContext<CommandSourceStack> context, CommandSender sender, CommandSender target) {
        String message = (String)context.getArgument("message", String.class);
        plugin.bundle().sendMessage((Audience)sender, "command.msg.outgoing", new TagResolver[]{Placeholder.parsed((String)"receiver", (String)target.getName()), Placeholder.parsed((String)"sender", (String)sender.getName()), Placeholder.parsed((String)"message", (String)message)});
        plugin.bundle().sendMessage((Audience)target, "command.msg.incoming", new TagResolver[]{Placeholder.parsed((String)"receiver", (String)target.getName()), Placeholder.parsed((String)"sender", (String)sender.getName()), Placeholder.parsed((String)"message", (String)message)});
        plugin.msgController().startConversation(target, sender);
    }
}

