/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.item;

import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.LiteralCommandNode;
import core.paper.item.ItemBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.Base64;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import net.thenextlvl.tweaks.command.suggestion.OfflinePlayerSuggestionProvider;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class HeadCommand {
    private final TweaksPlugin plugin;

    public HeadCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().head.command).requires(stack -> {
            Player player;
            CommandSender patt0$temp = stack.getSender();
            return patt0$temp instanceof Player && (player = (Player)patt0$temp).hasPermission("tweaks.command.head");
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"player").then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)new OfflinePlayerSuggestionProvider(this.plugin)).executes(this::playerHead))).executes(this::player))).then(((LiteralArgumentBuilder)Commands.literal((String)"url").then(Commands.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(this::urlHead))).executes(this::url))).then(((LiteralArgumentBuilder)Commands.literal((String)"value").then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(this::valueHead))).executes(this::value))).build();
        registrar.register(command, "Get heads or information about them", this.plugin.commands().head.aliases);
    }

    private int playerHead(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ItemBuilder head = ItemBuilder.of(Material.PLAYER_HEAD).profile((String)context.getArgument("player", String.class));
        player.getInventory().addItem(new ItemStack[]{head.item()});
        this.plugin.bundle().sendMessage((Audience)player, "command.item.head.received");
        return 1;
    }

    private int valueHead(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ItemBuilder head = ItemBuilder.of(Material.PLAYER_HEAD).profileValue((String)context.getArgument("value", String.class));
        player.getInventory().addItem(new ItemStack[]{head.item()});
        this.plugin.bundle().sendMessage((Audience)player, "command.item.head.received");
        return 1;
    }

    private int urlHead(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        ItemBuilder head = ItemBuilder.of(Material.PLAYER_HEAD).profileUrl((String)context.getArgument("url", String.class));
        player.getInventory().addItem(new ItemStack[]{head.item()});
        this.plugin.bundle().sendMessage((Audience)player, "command.item.head.received");
        return 1;
    }

    private int player(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        String owner = this.getOwner(player.getInventory().getItemInMainHand());
        if (owner != null) {
            this.plugin.bundle().sendMessage((Audience)player, "command.item.head.player", new TagResolver[]{Placeholder.parsed((String)"owner", (String)owner)});
        } else {
            this.plugin.bundle().sendMessage((Audience)player, "command.item.head.none");
        }
        return 1;
    }

    private int value(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        String value = HeadCommand.getValue(player.getInventory().getItemInMainHand());
        if (value != null) {
            this.plugin.bundle().sendMessage((Audience)player, "command.item.head.value", new TagResolver[]{Placeholder.parsed((String)"value", (String)(value.substring(0, Math.min(value.length(), 30)) + "\u2026")), Placeholder.parsed((String)"full_value", (String)value)});
        } else {
            this.plugin.bundle().sendMessage((Audience)player, "command.item.head.none");
        }
        return 1;
    }

    private int url(CommandContext<CommandSourceStack> context) {
        Player player = (Player)((CommandSourceStack)context.getSource()).getSender();
        String url = this.getUrl(player.getInventory().getItemInMainHand());
        if (url != null) {
            this.plugin.bundle().sendMessage((Audience)player, "command.item.head.url", new TagResolver[]{Placeholder.parsed((String)"url", (String)(url.substring(0, Math.min(url.length(), 30)) + "\u2026")), Placeholder.parsed((String)"full_url", (String)url)});
        } else {
            this.plugin.bundle().sendMessage((Audience)player, "command.item.head.none");
        }
        return 1;
    }

    private static @Nullable String getValue(ItemStack item) {
        ResolvableProfile profile = (ResolvableProfile)item.getData(DataComponentTypes.PROFILE);
        return profile != null ? (String)profile.properties().stream().filter(property -> property.getName().equalsIgnoreCase("textures")).findFirst().map(ProfileProperty::getValue).orElse(null) : null;
    }

    private @Nullable String getUrl(ItemStack item) {
        String value = HeadCommand.getValue(item);
        JsonElement json = value != null ? JsonParser.parseString((String)new String(Base64.getDecoder().decode(value))) : null;
        return json != null ? json.getAsJsonObject().getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString() : null;
    }

    private @Nullable String getOwner(ItemStack item) {
        ResolvableProfile profile = (ResolvableProfile)item.getData(DataComponentTypes.PROFILE);
        return profile != null ? profile.name() : null;
    }
}

