/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.tweaks.command.environment.time;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.util.function.Function;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.thenextlvl.tweaks.TweaksPlugin;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class TimeCommand {
    private final TweaksPlugin plugin;

    public TimeCommand(TweaksPlugin plugin) {
        this.plugin = plugin;
    }

    public void register(Commands registrar) {
        LiteralCommandNode command = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)this.plugin.commands().time.command).requires(stack -> stack.getSender().hasPermission("tweaks.command.time"))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set").then(this.setTime("afternoon", "tweaks.command.time.afternoon", 9000))).then(this.setTime("day", "tweaks.command.time.day", 1000))).then(this.setTime("midnight", "tweaks.command.time.midnight", 18000))).then(this.setTime("morning", "tweaks.command.time.morning", 0))).then(this.setTime("night", "tweaks.command.time.night", 13000))).then(this.setTime("noon", "tweaks.command.time.noon", 6000))).then(this.setTime("sunrise", "tweaks.command.time.sunrise", 23000))).then(this.setTime("sunset", "tweaks.command.time.sunset", 12000))).then(this.setTime()))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(stack -> stack.getSender().hasPermission("tweaks.command.time.add"))).then(((RequiredArgumentBuilder)Commands.argument((String)"time", (ArgumentType)ArgumentTypes.time()).then(Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes(context -> this.addTime((CommandContext<CommandSourceStack>)context, (World)context.getArgument("world", World.class))))).executes(context -> this.addTime((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getLocation().getWorld()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"query").requires(stack -> stack.getSender().hasPermission("tweaks.command.time.query"))).then(this.query("day", world -> world.getFullTime() / 24000L % Integer.MAX_VALUE))).then(this.query("daytime", world -> world.getFullTime() % 24000L))).then(this.query("gametime", world -> world.getGameTime() % Integer.MAX_VALUE)))).build();
        registrar.register(command, "Manage the time on your server", this.plugin.commands().time.aliases);
    }

    private LiteralArgumentBuilder<CommandSourceStack> query(String literal, Function<World, Long> function) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)literal).then(Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes(context -> this.query((CommandContext<CommandSourceStack>)context, (World)context.getArgument("world", World.class), function)))).executes(context -> this.query((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).getLocation().getWorld(), function));
    }

    private RequiredArgumentBuilder<CommandSourceStack, Integer> setTime() {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"time", (ArgumentType)ArgumentTypes.time()).requires(stack -> stack.getSender().hasPermission("tweaks.command.time.set"))).then(Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes(context -> {
            Integer time = (Integer)context.getArgument("time", Integer.TYPE);
            World world = (World)context.getArgument("world", World.class);
            return this.setTime((CommandContext<CommandSourceStack>)context, time.intValue(), world);
        }))).executes(context -> {
            Integer time = (Integer)context.getArgument("time", Integer.TYPE);
            World world = ((CommandSourceStack)context.getSource()).getLocation().getWorld();
            return this.setTime((CommandContext<CommandSourceStack>)context, time.intValue(), world);
        });
    }

    private LiteralArgumentBuilder<CommandSourceStack> setTime(String literal, String permission, int ticks) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)literal).requires(stack -> stack.getSender().hasPermission(permission))).then(Commands.argument((String)"world", (ArgumentType)ArgumentTypes.world()).executes(context -> this.setTime((CommandContext<CommandSourceStack>)context, ticks, (World)context.getArgument("world", World.class))))).executes(context -> this.setTime((CommandContext<CommandSourceStack>)context, ticks, ((CommandSourceStack)context.getSource()).getLocation().getWorld()));
    }

    private int setTime(CommandContext<CommandSourceStack> context, long ticks, World world) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        this.plugin.bundle().sendMessage((Audience)sender, "command.time.set", new TagResolver[]{Formatter.number((String)"time", (Number)ticks), Placeholder.parsed((String)"world", (String)world.getName())});
        world.setTime(ticks);
        return 1;
    }

    private int addTime(CommandContext<CommandSourceStack> context, World world) {
        Integer time = (Integer)context.getArgument("time", Integer.TYPE);
        return this.setTime(context, world.getTime() + (long)time.intValue(), world);
    }

    private int query(CommandContext<CommandSourceStack> context, World world, Function<World, Long> function) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        this.plugin.bundle().sendMessage((Audience)sender, "command.time.query", new TagResolver[]{Formatter.number((String)"time", (Number)function.apply(world)), Placeholder.parsed((String)"world", (String)world.getName())});
        return 1;
    }
}

