/*
 * Decompiled with CFR 0.152.
 */
package core.version.hangar;

import com.google.gson.Gson;
import core.version.Version;
import core.version.VersionChecker;
import core.version.hangar.HangarVersion;
import core.version.hangar.HangarVersions;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class HangarVersionChecker<V extends Version>
implements VersionChecker<HangarVersion, V> {
    private static final String API_URL = "https://hangar.papermc.io/api/v1/projects/%s/";
    private static final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).build();
    private static final Gson gson = new Gson();
    private Set<HangarVersion> versions = new HashSet<HangarVersion>();
    private final String slug;

    public HangarVersionChecker(String slug) {
        this.slug = slug;
    }

    public String getSlug() {
        return this.slug;
    }

    @Override
    public CompletableFuture<V> retrieveLatestVersion() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.get("latestrelease").thenApply(HttpResponse::body)).thenCompose(version -> this.get("versions/" + version))).thenApply(response -> {
            HangarVersion version = (HangarVersion)gson.fromJson((String)response.body(), HangarVersion.class);
            this.versions.add(version);
            return version;
        })).thenApply(this::parseVersion);
    }

    @Override
    public CompletableFuture<Set<V>> retrieveVersions() {
        return this.retrieveHangarVersions().thenApply(versions -> versions.stream().map(this::parseVersion).collect(Collectors.toUnmodifiableSet()));
    }

    @Override
    public CompletableFuture<Optional<V>> retrieveLatestSupportedVersion() {
        return this.retrieveHangarVersions().thenApply(versions -> versions.stream().filter(this::isSupported).map(this::parseVersion).max(Comparable::compareTo));
    }

    @Override
    public Set<V> getSupportedVersions() {
        return this.versions.stream().filter(this::isSupported).map(this::parseVersion).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<V> getVersions() {
        return this.versions.stream().map(this::parseVersion).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Optional<V> getLatestSupportedVersion() {
        return this.versions.stream().filter(this::isSupported).map(this::parseVersion).max(Comparable::compareTo);
    }

    @Override
    public Optional<V> getLatestVersion() {
        return this.versions.stream().map(this::parseVersion).max(Comparable::compareTo);
    }

    @Override
    public V parseVersion(HangarVersion version) {
        return this.parseVersion(version.name());
    }

    public final CompletableFuture<Set<HangarVersion>> retrieveHangarVersions() {
        return ((CompletableFuture)this.get("versions").thenApply(response -> {
            HangarVersions versions = (HangarVersions)gson.fromJson((String)response.body(), HangarVersions.class);
            this.versions = versions.result();
            return versions;
        })).thenApply(HangarVersions::result);
    }

    private CompletableFuture<HttpResponse<String>> get(String path) {
        return client.sendAsync(HttpRequest.newBuilder().uri(URI.create(API_URL.formatted(this.getSlug()) + path)).build(), HttpResponse.BodyHandlers.ofString());
    }
}

