/*
 * Decompiled with CFR 0.152.
 */
package core.paper.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import core.paper.cache.PlayerCache;
import core.paper.command.ComponentCommandExceptionType;
import core.paper.command.WrappedArgumentType;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class CustomArgumentTypes {
    private static final ComponentCommandExceptionType NO_PLAYER_FOUND = new ComponentCommandExceptionType((Component)Component.translatable((String)"argument.entity.notfound.player"));

    public static ArgumentType<OfflinePlayer> cachedOfflinePlayer() {
        return new WrappedArgumentType<String, OfflinePlayer>((ArgumentType<String>)StringArgumentType.word(), (reader, name) -> {
            OfflinePlayer player = Bukkit.getOfflinePlayerIfCached((String)name);
            if (player != null) {
                return player;
            }
            throw NO_PLAYER_FOUND.createWithContext((ImmutableStringReader)reader);
        }, (context, builder) -> CompletableFuture.supplyAsync(() -> {
            PlayerCache.getOfflinePlayers().map(OfflinePlayer::getName).filter(Objects::nonNull).filter(s -> s.toLowerCase().contains(builder.getRemainingLowerCase())).limit(100L).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.build();
        }));
    }

    public static ArgumentType<Player> playerExact() {
        return new WrappedArgumentType<String, Player>((ArgumentType<String>)StringArgumentType.word(), (reader, name) -> {
            Player player = Bukkit.getPlayerExact((String)name);
            if (player != null) {
                return player;
            }
            throw NO_PLAYER_FOUND.createWithContext((ImmutableStringReader)reader);
        }, (context, builder) -> CompletableFuture.supplyAsync(() -> {
            Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(s -> s.toLowerCase().contains(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.build();
        }));
    }

    public static ArgumentType<Player> player() {
        return new WrappedArgumentType<String, Player>((ArgumentType<String>)StringArgumentType.word(), (reader, name) -> {
            Player player = Bukkit.getPlayer((String)name);
            if (player != null) {
                return player;
            }
            throw NO_PLAYER_FOUND.createWithContext((ImmutableStringReader)reader);
        }, (context, builder) -> CompletableFuture.supplyAsync(() -> {
            Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(s -> s.toLowerCase().contains(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.build();
        }));
    }
}

