/*
 * Decompiled with CFR 0.152.
 */
package core.paper.cache;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PlayerCache {
    private static final File playerData = new File(new File(Bukkit.getWorldContainer(), "world"), "playerdata");

    public static Stream<OfflinePlayer> getOfflinePlayers() {
        return PlayerCache.getStoredPlayers().stream().map(Bukkit::getOfflinePlayer);
    }

    private static Set<UUID> getStoredPlayers() {
        HashSet<UUID> players = new HashSet<UUID>();
        String[] names = playerData.list((dir, name) -> name.endsWith(".dat"));
        if (names == null) {
            return new HashSet<UUID>();
        }
        for (String name2 : names) {
            try {
                players.add(UUID.fromString(name2.substring(0, name2.length() - 4)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return players;
    }
}

