/*
 * Decompiled with CFR 0.152.
 */
package core.nbt.tag;

import core.nbt.NBTInputStream;
import core.nbt.NBTOutputStream;
import core.nbt.tag.ValueTag;
import java.io.IOException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StringTag
extends ValueTag<String> {
    public static final int ID = 8;

    public StringTag(String value) {
        super(value);
    }

    @Override
    public final boolean isString() {
        return true;
    }

    @Override
    public String getAsString() {
        return (String)this.getValue();
    }

    @Override
    public int getTypeId() {
        return 8;
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        byte[] bytes = ((String)this.getValue()).getBytes(outputStream.getCharset());
        outputStream.writeShort(bytes.length);
        outputStream.write(bytes);
    }

    public static StringTag read(NBTInputStream inputStream) throws IOException {
        short length = inputStream.readShort();
        byte[] bytes = new byte[length];
        inputStream.readFully(bytes);
        String value = new String(bytes, inputStream.getCharset());
        return new StringTag(value);
    }
}

