/*
 * Decompiled with CFR 0.152.
 */
package core.nbt.tag;

import core.nbt.NBTInputStream;
import core.nbt.NBTOutputStream;
import core.nbt.tag.IterableTag;
import core.nbt.tag.ValueTag;
import java.io.IOException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class LongArrayTag
extends ValueTag<long[]>
implements IterableTag<Long> {
    public static final int ID = 12;

    public LongArrayTag(long ... value) {
        super(value);
    }

    @Override
    public int getTypeId() {
        return 12;
    }

    @Override
    public int size() {
        return ((long[])this.getValue()).length;
    }

    @Override
    public Long get(int index) {
        return ((long[])this.getValue())[index];
    }

    @Override
    public void set(int index, Long element) {
        ((long[])this.getValue())[index] = element;
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeLong(((long[])this.getValue()).length);
        for (long l : (long[])this.getValue()) {
            outputStream.writeLong(l);
        }
    }

    public static LongArrayTag read(NBTInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = inputStream.readLong();
        }
        return new LongArrayTag(array);
    }
}

