/*
 * Decompiled with CFR 0.152.
 */
package core.nbt.tag;

import core.nbt.NBTInputStream;
import core.nbt.NBTOutputStream;
import core.nbt.tag.Tag;
import core.nbt.tag.ValueTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ListTag<V extends Tag>
extends ValueTag<List<V>>
implements List<V> {
    public static final int ID = 9;
    private final int contentTypeId;

    public ListTag(List<V> value, int contentTypeId) {
        super(value);
        this.contentTypeId = contentTypeId;
        if (value.isEmpty()) {
            return;
        }
        Tag first = (Tag)value.getFirst();
        if (first.getTypeId() != contentTypeId) {
            throw new IllegalArgumentException("ListTag content type mismatch");
        }
    }

    public ListTag(List<V> value) {
        super(value);
        if (value.isEmpty()) {
            throw new IllegalArgumentException("ListTag without type must have at least one element");
        }
        this.contentTypeId = ((Tag)value.getFirst()).getTypeId();
    }

    public ListTag(int contentTypeId) {
        this(new ArrayList(), contentTypeId);
    }

    public int getContentTypeId() {
        return this.contentTypeId;
    }

    @Override
    public final boolean isList() {
        return true;
    }

    @Override
    public ListTag<V> getAsList() {
        return this;
    }

    @Override
    public int getTypeId() {
        return 9;
    }

    @Override
    public int size() {
        return ((List)this.getValue()).size();
    }

    @Override
    public boolean isEmpty() {
        return ((List)this.getValue()).isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return ((List)this.getValue()).contains(o);
    }

    @Override
    public Iterator<V> iterator() {
        return ((List)this.getValue()).iterator();
    }

    @Override
    public Object[] toArray() {
        return ((List)this.getValue()).toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return ((List)this.getValue()).toArray(ts);
    }

    @Override
    public boolean add(V v) {
        if (v.getTypeId() == this.contentTypeId) {
            return ((List)this.getValue()).add(v);
        }
        throw new IllegalArgumentException("ListTag content type mismatch");
    }

    @Override
    public boolean remove(Object o) {
        return ((List)this.getValue()).remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return new HashSet((Collection)this.getValue()).containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends V> collection) {
        return ((List)this.getValue()).addAll(collection);
    }

    @Override
    public boolean addAll(int i, Collection<? extends V> collection) {
        return ((List)this.getValue()).addAll(i, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return ((List)this.getValue()).removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return ((List)this.getValue()).retainAll(collection);
    }

    @Override
    public void clear() {
        ((List)this.getValue()).clear();
    }

    @Override
    public V get(int i) {
        return (V)((Tag)((List)this.getValue()).get(i));
    }

    @Override
    public V set(int i, V v) {
        return (V)((Tag)((List)this.getValue()).set(i, v));
    }

    @Override
    public void add(int i, V v) {
        if (v.getTypeId() != this.contentTypeId) {
            throw new IllegalArgumentException("ListTag content type mismatch");
        }
        ((List)this.getValue()).add(i, v);
    }

    @Override
    public V remove(int i) {
        return (V)((Tag)((List)this.getValue()).remove(i));
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.getValue()).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.getValue()).lastIndexOf(o);
    }

    @Override
    public ListIterator<V> listIterator() {
        return ((List)this.getValue()).listIterator();
    }

    @Override
    public ListIterator<V> listIterator(int i) {
        return ((List)this.getValue()).listIterator(i);
    }

    @Override
    public List<V> subList(int i, int i1) {
        return ((List)this.getValue()).subList(i, i1);
    }

    @Override
    public String toString() {
        return "ListTag{contentTypeId=" + this.contentTypeId + ", value=" + String.valueOf(super.getValue()) + "}";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListTag listTag = (ListTag)o;
        return this.contentTypeId == listTag.contentTypeId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.contentTypeId);
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.getContentTypeId());
        outputStream.writeInt(((List)this.getValue()).size());
        for (Tag tag : (List)this.getValue()) {
            tag.write(outputStream);
        }
    }

    public static <V extends Tag> ListTag<V> read(NBTInputStream inputStream) throws IOException {
        byte type = inputStream.readByte();
        int length = inputStream.readInt();
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (int i = 0; i < length; ++i) {
            list.add(inputStream.readTag(type));
        }
        return new ListTag(list, type);
    }
}

