/*
 * Decompiled with CFR 0.152.
 */
package core.nbt.tag;

import core.nbt.NBTInputStream;
import core.nbt.NBTOutputStream;
import core.nbt.tag.IterableTag;
import core.nbt.tag.ValueTag;
import java.io.IOException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class IntArrayTag
extends ValueTag<int[]>
implements IterableTag<Integer> {
    public static final int ID = 11;

    public IntArrayTag(int ... value) {
        super(value);
    }

    @Override
    public int getTypeId() {
        return 11;
    }

    @Override
    public int size() {
        return ((int[])this.getValue()).length;
    }

    @Override
    public Integer get(int index) {
        return ((int[])this.getValue())[index];
    }

    @Override
    public void set(int index, Integer element) {
        ((int[])this.getValue())[index] = element;
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeInt(((int[])this.getValue()).length);
        for (int i : (int[])this.getValue()) {
            outputStream.writeInt(i);
        }
    }

    public static IntArrayTag read(NBTInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = inputStream.readInt();
        }
        return new IntArrayTag(array);
    }
}

