/*
 * Decompiled with CFR 0.152.
 */
package core.nbt.tag;

import core.nbt.NBTInputStream;
import core.nbt.NBTOutputStream;
import core.nbt.tag.ByteArrayTag;
import core.nbt.tag.ByteTag;
import core.nbt.tag.DoubleTag;
import core.nbt.tag.EscapeTag;
import core.nbt.tag.FloatTag;
import core.nbt.tag.IntArrayTag;
import core.nbt.tag.IntTag;
import core.nbt.tag.ListTag;
import core.nbt.tag.LongArrayTag;
import core.nbt.tag.LongTag;
import core.nbt.tag.ShortTag;
import core.nbt.tag.StringTag;
import core.nbt.tag.Tag;
import core.nbt.tag.ValueTag;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CompoundTag
extends ValueTag<Map<String, Tag>> {
    public static final int ID = 10;

    public CompoundTag(Map<String, Tag> value) {
        super(value);
    }

    public CompoundTag() {
        this((Map<String, Tag>)new HashMap<String, Tag>());
    }

    @Override
    public final boolean isCompound() {
        return true;
    }

    @Override
    public CompoundTag getAsCompound() {
        return this;
    }

    @Override
    public int getTypeId() {
        return 10;
    }

    public void add(String name, Tag tag) {
        ((Map)this.getValue()).put(name, tag);
    }

    public @Nullable Tag remove(String name) {
        return (Tag)((Map)this.getValue()).remove(name);
    }

    public void add(String name, String value) {
        this.add(name, new StringTag(value));
    }

    public void add(String name, byte[] value) {
        this.add(name, new ByteArrayTag(value));
    }

    public void add(String name, int[] value) {
        this.add(name, new IntArrayTag(value));
    }

    public void add(String name, long[] value) {
        this.add(name, new LongArrayTag(value));
    }

    public void add(String name, Number number) {
        Number number2 = number;
        Objects.requireNonNull(number2);
        Number number3 = number2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Float.class, Short.class, Long.class, Byte.class}, (Object)number3, n)) {
            case 0: {
                Integer value = (Integer)number3;
                this.add(name, new IntTag(value));
                break;
            }
            case 1: {
                Float value = (Float)number3;
                this.add(name, new FloatTag(value));
                break;
            }
            case 2: {
                Short value = (Short)number3;
                this.add(name, new ShortTag(value));
                break;
            }
            case 3: {
                Long value = (Long)number3;
                this.add(name, new LongTag(value));
                break;
            }
            case 4: {
                Byte value = (Byte)number3;
                this.add(name, new ByteTag(value));
                break;
            }
            default: {
                this.add(name, new DoubleTag(number.doubleValue()));
            }
        }
    }

    public void add(String name, Boolean value) {
        this.add(name, new ByteTag(value != false ? (byte)1 : 0));
    }

    public void addAll(CompoundTag tag) {
        tag.forEach(this::add);
    }

    public void forEach(BiConsumer<? super String, ? super Tag> action) {
        ((Map)this.getValue()).forEach(action);
    }

    public Set<Map.Entry<String, Tag>> entrySet() {
        return ((Map)this.getValue()).entrySet();
    }

    public Set<String> keySet() {
        return ((Map)this.getValue()).keySet();
    }

    public boolean isEmpty() {
        return ((Map)this.getValue()).isEmpty();
    }

    public int size() {
        return ((Map)this.getValue()).size();
    }

    public boolean containsKey(String property) {
        return ((Map)this.getValue()).containsKey(property);
    }

    @NullUnmarked
    public <T extends Tag> T get(String property) {
        return (T)((Tag)((Map)this.getValue()).get(property));
    }

    public <E extends Tag> ListTag<E> getAsList(String tag) {
        return this.get(tag).getAsList();
    }

    public CompoundTag getAsCompound(String tag) {
        return this.get(tag).getAsCompound();
    }

    public <T extends Tag> T getOrAdd(String tag, T defaultValue) {
        T value = this.get(tag);
        if (value != null) {
            return value;
        }
        this.add(tag, defaultValue);
        return defaultValue;
    }

    @NullUnmarked
    public <T extends Tag> T getOrDefault(String tag, T defaultValue) {
        return ((Map)this.getValue()).getOrDefault(tag, defaultValue);
    }

    public <T extends Tag> Optional<T> optional(String tag) {
        return Optional.ofNullable(this.get(tag)).map(value -> (Tag)value);
    }

    public Builder toBuilder() {
        return new Builder(new HashMap<String, Tag>((Map)this.getValue()));
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        for (Map.Entry<String, Tag> entry : this.entrySet()) {
            outputStream.writeTag(entry.getKey(), entry.getValue());
        }
        EscapeTag.INSTANCE.write(outputStream);
    }

    public static CompoundTag read(NBTInputStream inputStream) throws IOException {
        Map.Entry<Tag, Optional<String>> entry;
        HashMap<String, Tag> value = new HashMap<String, Tag>();
        while (!(entry = inputStream.readNamedTag()).getValue().isEmpty()) {
            value.put(entry.getValue().get(), entry.getKey());
        }
        return new CompoundTag((Map<String, Tag>)value);
    }

    public static Builder builder() {
        return new Builder(new HashMap<String, Tag>());
    }

    public static class Builder {
        private final Map<String, Tag> values;

        private Builder(Map<String, Tag> values) {
            this.values = values;
        }

        public Builder put(String name, Boolean value) {
            return this.put(name, new ByteTag(value != false ? (byte)1 : 0));
        }

        public Builder put(String name, byte ... array) {
            return this.put(name, new ByteArrayTag(array));
        }

        public Builder put(String name, int ... array) {
            return this.put(name, new IntArrayTag(array));
        }

        public Builder put(String name, long ... array) {
            return this.put(name, new LongArrayTag(array));
        }

        public Builder put(String name, Number number) {
            Number number2 = number;
            Objects.requireNonNull(number2);
            Number number3 = number2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Float.class, Short.class, Long.class, Byte.class}, (Object)number3, n)) {
                case 0 -> {
                    Integer value = (Integer)number3;
                    yield this.put(name, new IntTag(value));
                }
                case 1 -> {
                    Float value = (Float)number3;
                    yield this.put(name, new FloatTag(value));
                }
                case 2 -> {
                    Short value = (Short)number3;
                    yield this.put(name, new ShortTag(value));
                }
                case 3 -> {
                    Long value = (Long)number3;
                    yield this.put(name, new LongTag(value));
                }
                case 4 -> {
                    Byte value = (Byte)number3;
                    yield this.put(name, new ByteTag(value));
                }
                default -> this.put(name, new DoubleTag(number.doubleValue()));
            };
        }

        public Builder put(String name, String value) {
            return this.put(name, new StringTag(value));
        }

        public Builder put(String name, Tag tag) {
            this.values.put(name, tag);
            return this;
        }

        public Builder putAll(CompoundTag tag) {
            this.values.putAll((Map)tag.getValue());
            return this;
        }

        public CompoundTag build() {
            return new CompoundTag(this.values);
        }
    }
}

