/*
 * Decompiled with CFR 0.152.
 */
package core.nbt.tag;

import core.nbt.NBTInputStream;
import core.nbt.NBTOutputStream;
import core.nbt.tag.NumberTag;
import java.io.IOException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ByteTag
extends NumberTag<Byte> {
    public static final int ID = 1;

    public ByteTag(Byte value) {
        super(value);
    }

    @Override
    public boolean getAsBoolean() {
        return (Byte)this.getValue() == 1;
    }

    @Override
    public byte getAsByte() {
        return (Byte)this.getValue();
    }

    @Override
    public int getTypeId() {
        return 1;
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.write(((Byte)this.getValue()).byteValue());
    }

    public static ByteTag read(NBTInputStream inputStream) throws IOException {
        return new ByteTag(inputStream.readByte());
    }
}

