/*
 * Decompiled with CFR 0.152.
 */
package core.nbt.tag;

import core.nbt.NBTInputStream;
import core.nbt.NBTOutputStream;
import core.nbt.tag.IterableTag;
import core.nbt.tag.ValueTag;
import java.io.IOException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ByteArrayTag
extends ValueTag<byte[]>
implements IterableTag<Byte> {
    public static final int ID = 7;

    public ByteArrayTag(byte ... array) {
        super(array);
    }

    @Override
    public int getTypeId() {
        return 7;
    }

    @Override
    public int size() {
        return ((byte[])this.getValue()).length;
    }

    @Override
    public Byte get(int index) {
        return ((byte[])this.getValue())[index];
    }

    @Override
    public void set(int index, Byte element) {
        ((byte[])this.getValue())[index] = element;
    }

    @Override
    public void write(NBTOutputStream outputStream) throws IOException {
        outputStream.writeInt(((byte[])this.getValue()).length);
        outputStream.write((byte[])this.getValue());
    }

    public static ByteArrayTag read(NBTInputStream inputStream) throws IOException {
        int length = inputStream.readInt();
        byte[] bytes = new byte[length];
        inputStream.readFully(bytes);
        return new ByteArrayTag(bytes);
    }
}

