/*
 * Decompiled with CFR 0.152.
 */
package core.nbt.file;

import core.file.FileIO;
import core.io.IO;
import core.nbt.NBTInputStream;
import core.nbt.NBTOutputStream;
import core.nbt.tag.CompoundTag;
import core.nbt.tag.Tag;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class NBTFile<R extends CompoundTag>
extends FileIO<R> {
    private @Nullable String rootName;

    public NBTFile(@NonNull IO io, @NonNull Charset charset, R root) {
        super(io, charset, root);
    }

    public NBTFile(@NonNull IO io, R root) {
        super(io, root);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected R load() {
        if (!this.getIO().exists(new LinkOption[0])) {
            return (R)((CompoundTag)this.getRoot());
        }
        try (NBTInputStream inputStream = new NBTInputStream(this.getIO().inputStream(StandardOpenOption.READ), this.getCharset());){
            Map.Entry<Tag, Optional<String>> entry = inputStream.readNamedTag();
            entry.getValue().ifPresent(this::setRootName);
            CompoundTag compoundTag = (CompoundTag)entry.getKey();
            return (R)compoundTag;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public @NonNull FileIO<R> save(FileAttribute<?> ... attributes) {
        NBTFile nBTFile;
        this.getIO().createParents(attributes);
        CompoundTag root = (CompoundTag)this.getRoot();
        NBTOutputStream outputStream = new NBTOutputStream(this.getIO().outputStream(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), this.getCharset());
        try {
            outputStream.writeTag(this.getRootName(), root);
            nBTFile = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        outputStream.close();
        return nBTFile;
    }

    public @Nullable String getRootName() {
        return this.rootName;
    }

    public void setRootName(@Nullable String rootName) {
        this.rootName = rootName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NBTFile nbtFile = (NBTFile)o;
        return Objects.equals(this.rootName, nbtFile.rootName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rootName);
    }

    @Override
    public String toString() {
        return "NBTFile{rootName='" + this.rootName + "'} " + super.toString();
    }
}

