/*
 * Decompiled with CFR 0.152.
 */
package core.nbt;

import core.nbt.tag.ByteArrayTag;
import core.nbt.tag.ByteTag;
import core.nbt.tag.CompoundTag;
import core.nbt.tag.DoubleTag;
import core.nbt.tag.EscapeTag;
import core.nbt.tag.FloatTag;
import core.nbt.tag.IntArrayTag;
import core.nbt.tag.IntTag;
import core.nbt.tag.ListTag;
import core.nbt.tag.LongArrayTag;
import core.nbt.tag.LongTag;
import core.nbt.tag.ShortTag;
import core.nbt.tag.StringTag;
import core.nbt.tag.Tag;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class NBTInputStream
extends DataInputStream {
    private final Charset charset;
    private final Map<Integer, MappingFunction> mapper = new HashMap<Integer, MappingFunction>(){
        {
            this.put(7, ByteArrayTag::read);
            this.put(1, ByteTag::read);
            this.put(10, CompoundTag::read);
            this.put(6, DoubleTag::read);
            this.put(0, ignored -> EscapeTag.INSTANCE);
            this.put(5, FloatTag::read);
            this.put(11, IntArrayTag::read);
            this.put(3, IntTag::read);
            this.put(9, ListTag::read);
            this.put(12, LongArrayTag::read);
            this.put(4, LongTag::read);
            this.put(2, ShortTag::read);
            this.put(8, StringTag::read);
        }
    };

    public NBTInputStream(InputStream inputStream) throws IOException {
        this(inputStream, StandardCharsets.UTF_8);
    }

    public NBTInputStream(InputStream inputStream, Charset charset) throws IOException {
        super(new DataInputStream(new GZIPInputStream(inputStream)));
        this.charset = charset;
    }

    public Tag readTag() throws IOException {
        return this.readNamedTag().getKey();
    }

    public Map.Entry<Tag, Optional<String>> readNamedTag() throws IOException {
        byte type = this.readByte();
        if (type == 0) {
            return Map.entry(EscapeTag.INSTANCE, Optional.empty());
        }
        byte[] bytes = new byte[this.readShort()];
        this.readFully(bytes);
        String name = bytes.length == 0 ? null : new String(bytes, this.getCharset());
        return Map.entry(this.readTag(type), Optional.ofNullable(name));
    }

    public Tag readTag(int type) throws IOException {
        MappingFunction mapping = this.mapper.get(type);
        if (mapping != null) {
            return mapping.map(this);
        }
        throw new IllegalArgumentException("Unknown tag type: " + type);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void registerMapping(int typeId, MappingFunction function) {
        this.mapper.put(typeId, function);
    }

    @FunctionalInterface
    public static interface MappingFunction {
        public Tag map(NBTInputStream var1) throws IOException;
    }
}

