/*
 * Decompiled with CFR 0.152.
 */
package core.io;

import core.io.PathIO;
import core.io.StreamIO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public interface IO {
    public InputStream inputStream(OpenOption ... var1) throws IOException;

    public OutputStream outputStream(OpenOption ... var1) throws IOException;

    public boolean createParents(FileAttribute<?> ... var1) throws IOException;

    public boolean exists(LinkOption ... var1);

    public boolean delete() throws IOException;

    public static PathIO of(URI uri) {
        return IO.of(Path.of(uri));
    }

    public static PathIO of(String first, String ... more) {
        return IO.of(Path.of(first, more));
    }

    public static PathIO of(File parent, String child) {
        return IO.of(new File(parent, child));
    }

    public static PathIO of(File file) {
        return IO.of(file.toPath());
    }

    public static PathIO of(Path path) {
        return new PathIO(path);
    }

    public static StreamIO ofResource(String resource) {
        return IO.of(IO.class.getClassLoader().getResourceAsStream(resource), null);
    }

    public static StreamIO of(@Nullable InputStream inputStream, @Nullable OutputStream outputStream) {
        if (inputStream == null && outputStream == null) {
            throw new IllegalArgumentException("In & Out can't be both null");
        }
        return new StreamIO(inputStream, outputStream);
    }
}

