/*
 * Decompiled with CFR 0.152.
 */
package core.file.format;

import core.file.FileIO;
import core.file.Validatable;
import core.io.IO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PropertiesFile
extends FileIO<Properties>
implements Validatable<Properties> {
    protected final Properties defaultRoot;

    public PropertiesFile(IO io, Charset charset, Properties root) {
        super(io, charset, root);
        this.defaultRoot = root;
    }

    public PropertiesFile(IO io, Charset charset) {
        this(io, charset, new Properties());
    }

    public PropertiesFile(IO io, Properties root) {
        this(io, StandardCharsets.UTF_8, root);
    }

    public PropertiesFile(IO io) {
        this(io, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Properties load() {
        if (!this.getIO().exists(new LinkOption[0])) {
            return (Properties)((Properties)this.getRoot()).clone();
        }
        try (InputStreamReader reader = new InputStreamReader(this.getIO().inputStream(StandardOpenOption.READ), this.getCharset());){
            Properties properties;
            try (BufferedReader buffer = new BufferedReader(reader);){
                Properties properties2 = new Properties();
                properties2.load(buffer);
                properties = properties2;
            }
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FileIO<Properties> save(FileAttribute<?> ... attributes) {
        PropertiesFile propertiesFile;
        this.getIO().createParents(attributes);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.getIO().outputStream(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), this.getCharset()));
        try {
            ((Properties)this.getRoot()).store(writer, null);
            propertiesFile = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return propertiesFile;
    }

    public PropertiesFile validate(Validatable.Scope scope) {
        Properties root = (Properties)this.getRoot();
        if (root == this.defaultRoot) {
            return this;
        }
        if (scope.isFiltering()) {
            root.entrySet().removeIf(entry -> !this.defaultRoot.containsKey(entry.getKey()));
        }
        if (scope.isFilling()) {
            this.merge(this.defaultRoot);
        }
        return this;
    }

    public PropertiesFile merge(Properties properties) {
        Properties root = (Properties)this.getRoot();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (root.containsKey(key)) {
                return;
            }
            root.put(key, value);
        }));
        return this;
    }
}

