/*
 * Decompiled with CFR 0.152.
 */
package core.file.format;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import core.file.FileIO;
import core.file.Validatable;
import core.io.IO;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class GsonFile<R>
extends FileIO<R>
implements Validatable<R> {
    protected final @Nullable R defaultRoot;
    private final Type type;
    private final Gson gson;

    public GsonFile(IO io, @Nullable R root, Type type, Gson gson) {
        super(io, root);
        this.defaultRoot = root;
        this.type = type;
        this.gson = gson;
    }

    public GsonFile(IO io, Type type, Gson gson) {
        this(io, null, type, gson);
    }

    public GsonFile(IO io, @Nullable R root, TypeToken<R> token, Gson gson) {
        this(io, root, token.getType(), gson);
    }

    public GsonFile(IO io, TypeToken<R> token, Gson gson) {
        this(io, null, token, gson);
    }

    public GsonFile(IO io, R root, Gson gson) {
        this(io, root, root.getClass(), gson);
    }

    public GsonFile(IO io, @Nullable R root, Type type) {
        this(io, root, type, new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().serializeNulls().create());
    }

    public GsonFile(IO io, Type type) {
        this(io, null, type);
    }

    public GsonFile(IO io, @Nullable R root, TypeToken<R> token) {
        this(io, root, token.getType());
    }

    public GsonFile(IO io, TypeToken<R> token) {
        this(io, null, token);
    }

    public GsonFile(IO io, R root) {
        this(io, root, root.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected @Nullable R load() {
        if (!this.getIO().exists(new LinkOption[0])) {
            return this.getRoot();
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader(this.getIO().inputStream(StandardOpenOption.READ), this.getCharset()));){
            Object root = this.getGson().fromJson(reader, this.getType());
            Object object = root != null ? root : this.defaultRoot;
            return (R)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NullMarked
    public FileIO<R> save(FileAttribute<?> ... attributes) {
        GsonFile gsonFile;
        this.getIO().createParents(attributes);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.getIO().outputStream(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), this.getCharset()));
        try {
            this.getGson().toJson(this.getRoot(), this.getType(), (Appendable)writer);
            gsonFile = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return gsonFile;
    }

    @Override
    public FileIO<R> validate(Validatable.Scope scope) {
        JsonElement validatedTree;
        if (!this.getIO().exists(new LinkOption[0])) {
            return this;
        }
        JsonElement defaultTree = this.getGson().toJsonTree(this.defaultRoot, this.getType());
        JsonElement currentTree = this.getGson().toJsonTree(this.getRoot(), this.getType());
        if (currentTree.equals(validatedTree = GsonFile.validate(scope, defaultTree, currentTree))) {
            return this;
        }
        return this.setRoot(this.getGson().fromJson(validatedTree, this.getType()));
    }

    public Gson getGson() {
        return this.gson;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GsonFile gsonFile = (GsonFile)o;
        return Objects.equals(this.defaultRoot, gsonFile.defaultRoot) && Objects.equals(this.type, gsonFile.type) && Objects.equals(this.gson, gsonFile.gson);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.defaultRoot, this.type, this.gson);
    }

    @Override
    public String toString() {
        return "GsonFile{defaultRoot=" + String.valueOf(this.defaultRoot) + ", type=" + String.valueOf(this.type) + ", gson=" + String.valueOf(this.gson) + "} " + super.toString();
    }

    private static JsonElement validate(Validatable.Scope scope, JsonElement defaultTree, JsonElement currentTree) {
        if (!defaultTree.isJsonObject() || !currentTree.isJsonObject()) {
            return currentTree;
        }
        return GsonFile.validate(scope, defaultTree.getAsJsonObject(), currentTree.getAsJsonObject());
    }

    private static JsonObject validate(Validatable.Scope scope, JsonObject defaultTree, JsonObject currentTree) {
        JsonObject currentCopy = currentTree.deepCopy();
        if (scope.isFiltering()) {
            GsonFile.filterUnused(defaultTree, currentCopy);
        }
        if (scope.isFilling()) {
            GsonFile.fillMissing(defaultTree, currentCopy);
        }
        return currentCopy;
    }

    private static void fillMissing(JsonObject defaultTree, JsonObject currentCopy) {
        defaultTree.entrySet().stream().filter(entry -> !currentCopy.has((String)entry.getKey())).forEach(entry -> currentCopy.add((String)entry.getKey(), (JsonElement)entry.getValue()));
    }

    private static void filterUnused(JsonObject defaultTree, JsonObject currentCopy) {
        currentCopy.entrySet().removeIf(entry -> !defaultTree.has((String)entry.getKey()));
    }
}

