/*
 * Decompiled with CFR 0.152.
 */
package net.thenextlvl.service.wrapper.service.model;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import net.thenextlvl.service.api.economy.bank.Bank;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class WrappedBank
implements Bank {
    private final @Nullable World world;
    private final Economy economy;
    private final Plugin provider;
    private final String name;

    public WrappedBank(String name, @Nullable World world, Economy economy, Plugin provider) {
        this.name = name;
        this.world = world;
        this.economy = economy;
        this.provider = provider;
    }

    @Override
    public BigDecimal deposit(Number amount) {
        return new BigDecimal(this.economy.bankDeposit((String)this.name, (double)amount.doubleValue()).balance);
    }

    @Override
    public BigDecimal getBalance() {
        return new BigDecimal(this.economy.bankBalance((String)this.name).balance);
    }

    @Override
    public BigDecimal withdraw(Number amount) {
        return new BigDecimal(this.economy.bankWithdraw((String)this.name, (double)amount.doubleValue()).balance);
    }

    @Override
    public Optional<World> getWorld() {
        return Optional.ofNullable(this.world);
    }

    @Override
    public UUID getOwner() {
        return Arrays.stream(this.provider.getServer().getOfflinePlayers()).filter(player -> this.economy.isBankOwner(this.name, (OfflinePlayer)player).transactionSuccess()).map(OfflinePlayer::getUniqueId).findAny().orElse(new UUID(0L, 0L));
    }

    @Override
    public void setBalance(Number balance) {
        double difference = balance.doubleValue() - this.getBalance().doubleValue();
        if (difference > 0.0) {
            this.deposit(difference);
        } else if (difference < 0.0) {
            this.withdraw(-difference);
        }
    }

    @Override
    public @Unmodifiable Set<UUID> getMembers() {
        return Arrays.stream(this.provider.getServer().getOfflinePlayers()).filter(player -> this.economy.isBankMember(this.name, (OfflinePlayer)player).transactionSuccess()).map(OfflinePlayer::getUniqueId).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean addMember(UUID uuid) {
        return false;
    }

    @Override
    public boolean isMember(UUID uuid) {
        return false;
    }

    @Override
    public boolean removeMember(UUID uuid) {
        return false;
    }

    @Override
    public boolean setOwner(UUID uuid) {
        return false;
    }
}

